/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantmappers.datadriven.data;

import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.constantmappers.datadriven.parser.MemberKey;
import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupScope;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetAnnotation;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetField;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.Expression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ExpressionTransformer;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ExpressionVisitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import daomephsta.unpick.impl.DataTypeUtils;
import daomephsta.unpick.impl.Utils;
import daomephsta.unpick.impl.constantmappers.datadriven.ExpressionEvaluator;
import daomephsta.unpick.impl.constantmappers.datadriven.data.ConstantReplacementInfo;
import daomephsta.unpick.impl.constantmappers.datadriven.data.GroupInfo;
import daomephsta.unpick.impl.constantmappers.datadriven.data.ScopedGroupInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public final class Data
extends UnpickV3Visitor {
    private final Logger logger;
    private final boolean lenient;
    public final IConstantResolver constantResolver;
    public final IInheritanceChecker inheritanceChecker;
    public final Map<DataType, GroupInfo> defaultGroups = new EnumMap<DataType, GroupInfo>(DataType.class);
    public final Map<String, GroupInfo> groups = new HashMap<String, GroupInfo>();
    public final Map<MemberKey, TargetField> targetFields = new HashMap<MemberKey, TargetField>();
    public final Map<MemberKey, TargetMethod> targetMethods = new HashMap<MemberKey, TargetMethod>();
    public final Map<String, TargetAnnotation> targetAnnotations = new HashMap<String, TargetAnnotation>();

    public Data(Logger logger, boolean lenient, IConstantResolver constantResolver, IInheritanceChecker inheritanceChecker) {
        this.logger = logger;
        this.lenient = lenient;
        this.constantResolver = constantResolver;
        this.inheritanceChecker = inheritanceChecker;
    }

    /*
     * Loose catch block
     */
    @Override
    public void visitGroupDefinition(GroupDefinition groupDefinition) {
        String groupDisplayName;
        GroupInfo existingInfo = groupDefinition.name() == null ? this.defaultGroups.computeIfAbsent(groupDefinition.dataType(), k -> new GroupInfo(groupDefinition.dataType(), groupDefinition.flags())) : this.groups.computeIfAbsent(groupDefinition.name(), k -> new GroupInfo(groupDefinition.dataType(), groupDefinition.flags()));
        String string = groupDisplayName = groupDefinition.name() == null ? "<default>" : groupDefinition.name();
        if (existingInfo.flags != groupDefinition.flags()) {
            Utils.throwOrWarn(this.logger, this.lenient, () -> "Flags mismatch for group " + groupDisplayName);
            return;
        }
        if (existingInfo.dataType != groupDefinition.dataType()) {
            Utils.throwOrWarn(this.logger, this.lenient, () -> "Data type mismatch for group " + groupDisplayName);
            return;
        }
        if (groupDefinition.scopes().isEmpty()) {
            this.addScopedGroupDefinition(groupDefinition, existingInfo.globalScope, groupDisplayName);
        } else {
            for (GroupScope scope : groupDefinition.scopes()) {
                GroupScope groupScope;
                Objects.requireNonNull(scope);
                int n = 0;
                ScopedGroupInfo existingScopedInfo = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupScope.Package.class, GroupScope.Class.class, GroupScope.Method.class}, (Object)groupScope, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        Object var11_12;
                        GroupScope.Package var9_10 = (GroupScope.Package)groupScope;
                        Object packageName = var11_12 = var9_10.packageName();
                        yield existingInfo.packageScopes.computeIfAbsent((String)packageName, k -> new ScopedGroupInfo());
                    }
                    case 1 -> {
                        Object var13_14;
                        Object var11_12 = (GroupScope.Class)groupScope;
                        Object className = var13_14 = ((GroupScope.Class)var11_12).className();
                        yield existingInfo.classScopes.computeIfAbsent((String)className, k -> new ScopedGroupInfo());
                    }
                    case 2 -> {
                        String var17_18;
                        Object var13_14 = (GroupScope.Method)groupScope;
                        String className = var17_18 = ((GroupScope.Method)var13_14).className();
                        String methodName = var17_18 = ((GroupScope.Method)var13_14).methodName();
                        String methodDesc = var17_18 = ((GroupScope.Method)var13_14).methodDesc();
                        yield existingInfo.methodScopes.computeIfAbsent(new MemberKey(className, methodName, methodDesc), k -> new ScopedGroupInfo());
                    }
                };
                this.addScopedGroupDefinition(groupDefinition, existingScopedInfo, groupDisplayName);
                continue;
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
    }

    private void addScopedGroupDefinition(GroupDefinition groupDefinition, ScopedGroupInfo existingScopedInfo, String groupDisplayName) {
        if (groupDefinition.format() != null) {
            if (existingScopedInfo.format != groupDefinition.format() && existingScopedInfo.format != null) {
                throw new UnpickSyntaxException("Format mismatch for group " + groupDisplayName);
            }
            existingScopedInfo.format = groupDefinition.format();
        }
        for (Expression expression : groupDefinition.constants()) {
            for (Expression nonWildcardExpression : this.replaceWildcardIfNecessary(expression, groupDefinition.dataType(), groupDisplayName)) {
                ExpressionEvaluator evaluator = new ExpressionEvaluator(this.constantResolver, this.inheritanceChecker);
                nonWildcardExpression.accept(evaluator);
                Object value = DataTypeUtils.cast(evaluator.getResult(), groupDefinition.dataType());
                if (existingScopedInfo.constantReplacementMap.put(value, new ConstantReplacementInfo(groupDefinition.strict(), nonWildcardExpression)) == null) continue;
                Utils.throwOrWarn(this.logger, this.lenient, () -> "Duplicate constant in group " + groupDisplayName + ": " + String.valueOf(value));
            }
        }
    }

    private List<Expression> replaceWildcardIfNecessary(Expression expression, DataType groupType, String groupDisplayName) {
        FieldExpression wildcardExpr = Data.findWildcardFieldExpression(expression, groupDisplayName);
        if (wildcardExpr == null) {
            return List.of(expression);
        }
        Map<String, IConstantResolver.ResolvedConstant> constants = this.constantResolver.getAllConstantsInClass(wildcardExpr.className.replace('.', '/'));
        if (constants == null) {
            throw new UnpickSyntaxException("Could not resolve class " + wildcardExpr.className + " in group " + groupDisplayName);
        }
        ArrayList<Expression> replacements = new ArrayList<Expression>();
        constants.forEach((fieldName, resolvedConstant) -> {
            if (resolvedConstant.isStatic() != wildcardExpr.isStatic) {
                return;
            }
            DataType resolvedConstantType = DataTypeUtils.asmTypeToDataType(resolvedConstant.type());
            if (wildcardExpr.fieldType != null ? resolvedConstantType != wildcardExpr.fieldType : !DataTypeUtils.isAssignable(groupType, resolvedConstantType)) {
                return;
            }
            Expression replacement = expression.transform(new ExpressionTransformer(this, (String)fieldName, resolvedConstantType){
                final /* synthetic */ String val$fieldName;
                final /* synthetic */ DataType val$resolvedConstantType;
                {
                    this.val$fieldName = string;
                    this.val$resolvedConstantType = dataType;
                }

                @Override
                public Expression transformFieldExpression(FieldExpression fieldExpression) {
                    if (fieldExpression.fieldName == null) {
                        return new FieldExpression(fieldExpression.className, this.val$fieldName, this.val$resolvedConstantType, fieldExpression.isStatic);
                    }
                    return super.transformFieldExpression(fieldExpression);
                }
            });
            replacements.add(replacement);
        });
        if (replacements.isEmpty()) {
            throw new UnpickSyntaxException("Could not resolve wildcard field expression " + wildcardExpr.className + ".* in group " + groupDisplayName);
        }
        return replacements;
    }

    @Nullable
    private static FieldExpression findWildcardFieldExpression(Expression expression, final String groupDisplayName) {
        final FieldExpression[] result = new FieldExpression[]{null};
        expression.accept(new ExpressionVisitor(){

            @Override
            public void visitFieldExpression(FieldExpression fieldExpression) {
                if (fieldExpression.fieldName == null) {
                    if (result[0] != null) {
                        throw new UnpickSyntaxException("Expression in group " + groupDisplayName + " has multiple wildcard field expressions");
                    }
                    result[0] = fieldExpression;
                }
            }
        });
        return result[0];
    }

    @Override
    public void visitTargetField(TargetField targetField) {
        if (this.targetFields.put(new MemberKey(targetField.className(), targetField.fieldName(), targetField.fieldDesc()), targetField) != null) {
            Utils.throwOrWarn(this.logger, this.lenient, () -> "Duplicate target field: " + targetField.className() + "." + targetField.fieldName());
        }
    }

    @Override
    public void visitTargetMethod(TargetMethod targetMethod) {
        String returnGroup;
        MemberKey key = new MemberKey(targetMethod.className(), targetMethod.methodName(), targetMethod.methodDesc());
        TargetMethod existingTargetMethod = this.targetMethods.get(key);
        if (existingTargetMethod == null) {
            this.targetMethods.put(key, targetMethod);
            return;
        }
        HashMap<Integer, String> paramGroups = new HashMap<Integer, String>(existingTargetMethod.paramGroups());
        targetMethod.paramGroups().forEach((paramIndex, groupName) -> {
            if (paramGroups.put((Integer)paramIndex, (String)groupName) != null) {
                Utils.throwOrWarn(this.logger, this.lenient, () -> "Duplicate param group: " + targetMethod.className() + "." + targetMethod.methodName() + targetMethod.methodDesc() + " " + paramIndex);
            }
        });
        if (targetMethod.returnGroup() != null) {
            if (existingTargetMethod.returnGroup() != null) {
                Utils.throwOrWarn(this.logger, this.lenient, () -> "Duplicate return group: " + targetMethod.className() + "." + targetMethod.methodName() + targetMethod.methodDesc());
                return;
            }
            returnGroup = targetMethod.returnGroup();
        } else {
            returnGroup = existingTargetMethod.returnGroup();
        }
        TargetMethod merged = new TargetMethod(targetMethod.className(), targetMethod.methodName(), targetMethod.methodDesc(), paramGroups, returnGroup);
        this.targetMethods.put(key, merged);
    }

    @Override
    public void visitTargetAnnotation(TargetAnnotation targetAnnotation) {
        if (this.targetAnnotations.put(targetAnnotation.annotationName(), targetAnnotation) != null) {
            Utils.throwOrWarn(this.logger, this.lenient, () -> "Duplicate target annotation: " + targetAnnotation.annotationName());
        }
    }
}

