/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantmappers.datadriven;

import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.api.constantgroupers.IReplacementGenerator;
import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.Literal;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.BinaryExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.CastExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.Expression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ExpressionTransformer;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ExpressionVisitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.LiteralExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.UnaryExpression;
import daomephsta.unpick.impl.AbstractInsnNodes;
import daomephsta.unpick.impl.DataTypeUtils;
import daomephsta.unpick.impl.InstructionFactory;
import daomephsta.unpick.impl.constantmappers.datadriven.DataDrivenConstantGrouper;
import daomephsta.unpick.impl.constantmappers.datadriven.ExpressionEvaluator;
import daomephsta.unpick.impl.constantmappers.datadriven.data.GroupInfo;
import daomephsta.unpick.impl.constantmappers.datadriven.data.ScopedGroupInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Frame;

public final class ExpressionGenerator {
    private ExpressionGenerator() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Expression generateFlagsExpression(IReplacementGenerator.IContext context, GroupInfo groupInfo, long targetValue, DataType literalType, DataType narrowedLiteralType) {
        Expression oredFlags;
        long l;
        long mask = switch (narrowedLiteralType) {
            case DataType.BYTE -> 255L;
            case DataType.SHORT, DataType.CHAR -> 65535L;
            case DataType.INT -> 0xFFFFFFFFL;
            case DataType.LONG -> -1L;
            default -> throw new AssertionError((Object)("Invalid literal type for flag: " + String.valueOf((Object)narrowedLiteralType)));
        };
        targetValue &= mask;
        LinkedHashMap inScopeFlags = new LinkedHashMap();
        for (ScopedGroupInfo scope : DataDrivenConstantGrouper.findMatchingScopes(context, groupInfo)) {
            scope.constantReplacementMap.forEach((key, replacementInfo) -> {
                if (!replacementInfo.strict() || literalType == groupInfo.dataType) {
                    inScopeFlags.putIfAbsent((Long)DataTypeUtils.cast(key, DataType.LONG) & mask, replacementInfo.replacementExpression());
                }
            });
        }
        ArrayList flagList = new ArrayList(inScopeFlags.entrySet());
        flagList.sort(Map.Entry.comparingByKey(Comparator.comparingInt(Long::bitCount).reversed()));
        ArrayList<Expression> positiveSet = new ArrayList<Expression>();
        long residual = targetValue;
        for (Map.Entry entry : flagList) {
            if (((Long)entry.getKey() & (targetValue ^ 0xFFFFFFFFFFFFFFFFL)) != 0L || ((Long)entry.getKey() & residual) == 0L) continue;
            residual &= (Long)entry.getKey() ^ 0xFFFFFFFFFFFFFFFFL;
            positiveSet.add((Expression)entry.getValue());
        }
        ArrayList<Expression> negativeSet = new ArrayList<Expression>();
        long inverseResidual = l = targetValue ^ mask;
        for (Map.Entry entry : flagList) {
            if (((Long)entry.getKey() & (l ^ 0xFFFFFFFFFFFFFFFFL)) != 0L || ((Long)entry.getKey() & inverseResidual) == 0L) continue;
            inverseResidual &= (Long)entry.getKey() ^ 0xFFFFFFFFFFFFFFFFL;
            negativeSet.add((Expression)entry.getValue());
        }
        if (inverseResidual == 0L && (residual != 0L || negativeSet.size() < positiveSet.size())) {
            void var19_17;
            oredFlags = (Expression)negativeSet.getFirst();
            if (literalType == DataType.INT && ExpressionGenerator.getExpressionType(context, oredFlags) == DataType.LONG) {
                oredFlags = new CastExpression(narrowedLiteralType, oredFlags);
            }
            boolean bl = true;
            while (var19_17 < negativeSet.size()) {
                Expression nextExpr = (Expression)negativeSet.get((int)var19_17);
                if (literalType == DataType.INT && ExpressionGenerator.getExpressionType(context, nextExpr) == DataType.LONG) {
                    nextExpr = new CastExpression(narrowedLiteralType, nextExpr);
                }
                oredFlags = new BinaryExpression(oredFlags, nextExpr, BinaryExpression.Operator.BIT_OR);
                ++var19_17;
            }
            return new UnaryExpression(oredFlags, UnaryExpression.Operator.BIT_NOT);
        }
        if (!positiveSet.isEmpty()) {
            void var19_19;
            oredFlags = (Expression)positiveSet.getFirst();
            if (literalType == DataType.INT && ExpressionGenerator.getExpressionType(context, oredFlags) == DataType.LONG) {
                oredFlags = new CastExpression(narrowedLiteralType, oredFlags);
            }
            boolean bl = true;
            while (var19_19 < positiveSet.size()) {
                Expression nextExpr = (Expression)positiveSet.get((int)var19_19);
                if (literalType == DataType.INT && ExpressionGenerator.getExpressionType(context, nextExpr) == DataType.LONG) {
                    nextExpr = new CastExpression(narrowedLiteralType, nextExpr);
                }
                oredFlags = new BinaryExpression(oredFlags, nextExpr, BinaryExpression.Operator.BIT_OR);
                ++var19_19;
            }
            if (residual != 0L) {
                Record record = literalType == DataType.INT ? new Literal.Integer((int)residual) : new Literal.Long(residual);
                return new BinaryExpression(oredFlags, new LiteralExpression((Literal)((Object)record)), BinaryExpression.Operator.BIT_OR);
            }
            return oredFlags;
        }
        return null;
    }

    public static void replaceWithExpression(final IReplacementGenerator.IContext context, GroupInfo groupInfo, Expression replacement, DataType literalType) {
        AbstractInsnNode targetInsn = context.getTarget();
        if (replacement instanceof FieldExpression) {
            FieldExpression fieldReplacement = (FieldExpression)replacement;
            if (!fieldReplacement.isStatic) {
                Type topOfStack;
                Frame<IReplacementGenerator.IDataflowValue> dataflowFrame;
                AbstractInsnNode nullCheckStart;
                String fieldOwner = fieldReplacement.className.replace('.', '/');
                DataType fieldType = ExpressionGenerator.getFieldDataType(context, fieldReplacement);
                AbstractInsnNode nullCheckEnd = AbstractInsnNodes.previousInstruction(targetInsn);
                if (nullCheckEnd != null && (nullCheckStart = ExpressionGenerator.findStartOfNullCheck(nullCheckEnd, context.getContainingClass().version)) != null && (dataflowFrame = context.getDataflowFrame(nullCheckStart)) != null && (topOfStack = dataflowFrame.getStack(dataflowFrame.getStackSize() - 1).getDataType()).getSort() == 10 && context.getInheritanceChecker().isAssignableFrom(fieldOwner, topOfStack.getInternalName())) {
                    for (AbstractInsnNode insn = nullCheckStart; insn != nullCheckEnd; insn = insn.getNext()) {
                        context.getReplacementSet().addReplacement(insn, new InsnList());
                    }
                    context.getReplacementSet().addReplacement(nullCheckEnd, new InsnList());
                    context.getReplacementSet().addReplacement(targetInsn, new FieldInsnNode(180, fieldOwner, fieldReplacement.fieldName, DataTypeUtils.getDescriptor(fieldType)));
                    return;
                }
            }
        }
        final ArrayList instanceFieldExpressions = new ArrayList();
        replacement.accept(new ExpressionVisitor(){

            @Override
            public void visitFieldExpression(FieldExpression fieldExpression) {
                if (!fieldExpression.isStatic) {
                    instanceFieldExpressions.add(fieldExpression);
                }
            }
        });
        if ((context.getContainingMethod().access & 8) != 0 && !instanceFieldExpressions.isEmpty()) {
            return;
        }
        final HashMap<FieldExpression, List<FieldNode>> thisReferenceChains = new HashMap<FieldExpression, List<FieldNode>>();
        for (FieldExpression instanceFieldExpression : instanceFieldExpressions) {
            List<FieldNode> thisReferenceChain = ExpressionGenerator.getThisReferenceChain(context, instanceFieldExpression);
            if (thisReferenceChain == null) {
                return;
            }
            thisReferenceChains.put(instanceFieldExpression, thisReferenceChain);
        }
        replacement = ExpressionGenerator.propagateExpectedTypeDown(context, replacement, literalType);
        final InsnList replacementInsns = new InsnList();
        replacement.accept(new ExpressionVisitor(){

            @Override
            public void visitBinaryExpression(BinaryExpression binaryExpression) {
                DataType rightType;
                DataType leftType = ExpressionGenerator.getExpressionType(context, binaryExpression.lhs);
                DataType overallType = ExpressionEvaluator.getBinaryResultType(leftType, rightType = ExpressionGenerator.getExpressionType(context, binaryExpression.rhs));
                if (overallType == DataType.STRING) {
                    this.buildStringConcatenation(context, binaryExpression);
                    return;
                }
                binaryExpression.lhs.accept(this);
                ExpressionGenerator.addCastInsns(replacementInsns, leftType, overallType);
                binaryExpression.rhs.accept(this);
                boolean isShift = binaryExpression.operator == BinaryExpression.Operator.BIT_SHIFT_LEFT || binaryExpression.operator == BinaryExpression.Operator.BIT_SHIFT_RIGHT || binaryExpression.operator == BinaryExpression.Operator.BIT_SHIFT_RIGHT_UNSIGNED;
                ExpressionGenerator.addCastInsns(replacementInsns, rightType, isShift ? DataType.INT : overallType);
                int opcode = switch (binaryExpression.operator) {
                    default -> throw new MatchException(null, null);
                    case BinaryExpression.Operator.BIT_OR -> ExpressionGenerator.getOpcode(2.restrictToIntegralType(overallType), 128);
                    case BinaryExpression.Operator.BIT_XOR -> ExpressionGenerator.getOpcode(2.restrictToIntegralType(overallType), 130);
                    case BinaryExpression.Operator.BIT_AND -> ExpressionGenerator.getOpcode(2.restrictToIntegralType(overallType), 126);
                    case BinaryExpression.Operator.BIT_SHIFT_LEFT -> ExpressionGenerator.getOpcode(2.restrictToIntegralType(overallType), 120);
                    case BinaryExpression.Operator.BIT_SHIFT_RIGHT -> ExpressionGenerator.getOpcode(2.restrictToIntegralType(overallType), 122);
                    case BinaryExpression.Operator.BIT_SHIFT_RIGHT_UNSIGNED -> ExpressionGenerator.getOpcode(2.restrictToIntegralType(overallType), 124);
                    case BinaryExpression.Operator.ADD -> ExpressionGenerator.getOpcode(2.restrictToNumberType(overallType), 96);
                    case BinaryExpression.Operator.SUBTRACT -> ExpressionGenerator.getOpcode(2.restrictToNumberType(overallType), 100);
                    case BinaryExpression.Operator.MULTIPLY -> ExpressionGenerator.getOpcode(2.restrictToNumberType(overallType), 104);
                    case BinaryExpression.Operator.DIVIDE -> ExpressionGenerator.getOpcode(2.restrictToNumberType(overallType), 108);
                    case BinaryExpression.Operator.MODULO -> ExpressionGenerator.getOpcode(2.restrictToNumberType(overallType), 112);
                };
                replacementInsns.add(new InsnNode(opcode));
            }

            @Override
            public void visitCastExpression(CastExpression castExpression) {
                castExpression.operand.accept(this);
                DataType operandType = ExpressionGenerator.getExpressionType(context, castExpression.operand);
                ExpressionGenerator.addCastInsns(replacementInsns, operandType, castExpression.castType);
            }

            @Override
            public void visitFieldExpression(FieldExpression fieldExpression) {
                String fieldDesc = DataTypeUtils.getDescriptor(ExpressionGenerator.getFieldDataType(context, fieldExpression));
                if (fieldExpression.isStatic) {
                    String fieldOwner = fieldExpression.className.replace('.', '/');
                    replacementInsns.add(new FieldInsnNode(178, fieldOwner, fieldExpression.fieldName, fieldDesc));
                } else {
                    replacementInsns.add(new VarInsnNode(25, 0));
                    String thisType = context.getContainingClass().name;
                    for (FieldNode outerThisField : (List)thisReferenceChains.get(fieldExpression)) {
                        replacementInsns.add(new FieldInsnNode(180, thisType, outerThisField.name, outerThisField.desc));
                        thisType = Type.getType(outerThisField.desc).getInternalName();
                    }
                    replacementInsns.add(new FieldInsnNode(180, thisType, fieldExpression.fieldName, fieldDesc));
                }
            }

            @Override
            public void visitLiteralExpression(LiteralExpression literalExpression) {
                replacementInsns.add(InstructionFactory.pushValue(ExpressionGenerator.literalToObject(literalExpression.literal)));
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void visitUnaryExpression(UnaryExpression unaryExpression) {
                Expression expression;
                if (unaryExpression.operator == UnaryExpression.Operator.NEGATE && (expression = unaryExpression.operand) instanceof LiteralExpression) {
                    Literal literal;
                    LiteralExpression literalExpr = (LiteralExpression)expression;
                    Literal literal2 = literal = literalExpr.literal;
                    Objects.requireNonNull(literal2);
                    Literal literal3 = literal2;
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Literal.Integer.class, Literal.Long.class, Literal.Float.class, Literal.Double.class}, (Object)literal3, n)) {
                        case 0: {
                            Literal.Integer integer = (Literal.Integer)literal3;
                            try {
                                int n2;
                                int value = n2 = integer.value();
                                int ignored = n2 = integer.radix();
                                replacementInsns.add(InstructionFactory.pushInt(-value));
                                break;
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                        }
                        case 1: {
                            Literal.Long longVal = (Literal.Long)literal3;
                            {
                                int n3;
                                long l;
                                long value = l = longVal.value();
                                int ignored = n3 = longVal.radix();
                                replacementInsns.add(InstructionFactory.pushLong(-value));
                                break;
                            }
                        }
                        case 2: {
                            Literal.Float float_ = (Literal.Float)literal3;
                            {
                                float f;
                                float value = f = float_.value();
                                replacementInsns.add(InstructionFactory.pushFloat(-value));
                                break;
                            }
                        }
                        case 3: {
                            Literal.Double double_ = (Literal.Double)literal3;
                            {
                                double d;
                                double value = d = double_.value();
                                replacementInsns.add(InstructionFactory.pushDouble(-value));
                                break;
                            }
                        }
                    }
                }
                unaryExpression.operand.accept(this);
                DataType operandType = ExpressionGenerator.getExpressionType(context, unaryExpression.operand);
                switch (unaryExpression.operator) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NEGATE: {
                        replacementInsns.add(new InsnNode(ExpressionGenerator.getOpcode(2.restrictToNumberType(operandType), 116)));
                        return;
                    }
                    case BIT_NOT: {
                        if (2.restrictToIntegralType(operandType) == DataType.INT) {
                            replacementInsns.add(InstructionFactory.pushInt(-1));
                            replacementInsns.add(new InsnNode(130));
                            return;
                        } else {
                            replacementInsns.add(InstructionFactory.pushLong(-1L));
                            replacementInsns.add(new InsnNode(131));
                        }
                        return;
                    }
                }
            }

            private void buildStringConcatenation(IReplacementGenerator.IContext context2, BinaryExpression binaryExpr) {
                ArrayList<Expression> stuffToConcatenate = new ArrayList<Expression>();
                while (true) {
                    stuffToConcatenate.addFirst(binaryExpr.rhs);
                    if (!(binaryExpr.lhs instanceof BinaryExpression)) break;
                    binaryExpr = (BinaryExpression)binaryExpr.lhs;
                }
                stuffToConcatenate.addFirst(binaryExpr.lhs);
                if (context2.getContainingClass().version <= 52) {
                    replacementInsns.add(new TypeInsnNode(187, "java/lang/StringBuilder"));
                    replacementInsns.add(new InsnNode(89));
                    replacementInsns.add(new MethodInsnNode(183, "java/lang/StringBuilder", "<init>", "()V", false));
                    for (Expression expression : stuffToConcatenate) {
                        expression.accept(this);
                        String sbDesc = "(" + DataTypeUtils.getDescriptor(ExpressionGenerator.getExpressionType(context2, expression)) + ")Ljava/lang/StringBuilder;";
                        replacementInsns.add(new MethodInsnNode(182, "java/lang/StringBuilder", "append", sbDesc, false));
                    }
                    replacementInsns.add(new MethodInsnNode(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false));
                } else {
                    StringBuilder recipe = new StringBuilder(stuffToConcatenate.size());
                    StringBuilder concatType = new StringBuilder("(");
                    for (Expression expression : stuffToConcatenate) {
                        recipe.append('\u0001');
                        concatType.append(DataTypeUtils.getDescriptor(ExpressionGenerator.getExpressionType(context2, expression)));
                        expression.accept(this);
                    }
                    concatType.append(")Ljava/lang/String;");
                    replacementInsns.add(new InvokeDynamicInsnNode("makeConcatWithConstants", concatType.toString(), new Handle(6, "java/lang/invoke/StringConcatFactory", "makeConcatWithConstants", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false), recipe.toString()));
                }
            }

            private static DataType restrictToIntegralType(DataType dataType) {
                if (dataType == DataType.BYTE || dataType == DataType.SHORT || dataType == DataType.CHAR || dataType == DataType.INT) {
                    return DataType.INT;
                }
                return DataType.LONG;
            }

            private static DataType restrictToNumberType(DataType dataType) {
                return switch (dataType) {
                    case DataType.BYTE, DataType.SHORT, DataType.CHAR, DataType.INT -> DataType.INT;
                    case DataType.LONG -> DataType.LONG;
                    case DataType.FLOAT -> DataType.FLOAT;
                    default -> DataType.DOUBLE;
                };
            }
        });
        ExpressionGenerator.addCastInsns(replacementInsns, ExpressionGenerator.getExpressionType(context, replacement), literalType);
        context.getReplacementSet().addReplacement(targetInsn, replacementInsns);
    }

    private static Expression propagateExpectedTypeDown(final IReplacementGenerator.IContext context, Expression expression, final DataType expectedType) {
        return expression.transform(new ExpressionTransformer(){
            private DataType myExpectedType;
            {
                this.myExpectedType = expectedType;
            }

            @Override
            public Expression transformBinaryExpression(BinaryExpression binaryExpression) {
                DataType overallType;
                if (this.myExpectedType == DataType.STRING) {
                    return binaryExpression;
                }
                boolean isShift = binaryExpression.operator == BinaryExpression.Operator.BIT_SHIFT_LEFT || binaryExpression.operator == BinaryExpression.Operator.BIT_SHIFT_RIGHT || binaryExpression.operator == BinaryExpression.Operator.BIT_SHIFT_RIGHT_UNSIGNED;
                DataType leftType = ExpressionGenerator.getExpressionType(context, binaryExpression.lhs);
                DataType rightType = ExpressionGenerator.getExpressionType(context, binaryExpression.rhs);
                this.myExpectedType = overallType = ExpressionEvaluator.getBinaryResultType(ExpressionEvaluator.getBinaryResultType(leftType, rightType), this.myExpectedType);
                Expression lhs = binaryExpression.lhs.transform(this);
                this.myExpectedType = isShift ? DataType.INT : overallType;
                Expression rhs = binaryExpression.rhs.transform(this);
                return new BinaryExpression(lhs, rhs, binaryExpression.operator);
            }

            @Override
            public Expression transformCastExpression(CastExpression castExpression) {
                this.myExpectedType = castExpression.castType;
                return new CastExpression(castExpression.castType, castExpression.operand.transform(this));
            }

            @Override
            public Expression transformLiteralExpression(LiteralExpression literalExpression) {
                return new LiteralExpression(ExpressionGenerator.objectToLiteral(DataTypeUtils.cast(ExpressionGenerator.literalToObject(literalExpression.literal), this.myExpectedType)));
            }
        });
    }

    private static int getOpcode(DataType dataType, int intOpcode) {
        Type type = switch (dataType) {
            default -> throw new MatchException(null, null);
            case DataType.BYTE, DataType.SHORT, DataType.CHAR, DataType.INT -> Type.INT_TYPE;
            case DataType.LONG -> Type.LONG_TYPE;
            case DataType.FLOAT -> Type.FLOAT_TYPE;
            case DataType.DOUBLE -> Type.DOUBLE_TYPE;
            case DataType.STRING -> Type.getObjectType("java/lang/String");
            case DataType.CLASS -> Type.getObjectType("java/lang/Class");
        };
        return type.getOpcode(intOpcode);
    }

    private static void addCastInsns(InsnList insns, DataType fromType, DataType toType) {
        Integer opcode;
        block0 : switch (fromType) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: {
                Integer n;
                switch (toType) {
                    case BYTE: {
                        if (fromType != DataType.BYTE) {
                            insns.add(new InsnNode(145));
                        }
                        n = null;
                        break block0;
                    }
                    case SHORT: {
                        if (fromType != DataType.BYTE && fromType != DataType.SHORT) {
                            insns.add(new InsnNode(147));
                        }
                        n = null;
                        break block0;
                    }
                    case CHAR: {
                        if (fromType != DataType.CHAR) {
                            insns.add(new InsnNode(146));
                        }
                        n = null;
                        break block0;
                    }
                    case LONG: {
                        n = 133;
                        break block0;
                    }
                    case FLOAT: {
                        n = 134;
                        break block0;
                    }
                    case DOUBLE: {
                        n = 135;
                        break block0;
                    }
                }
                n = null;
                break;
            }
            case LONG: {
                Integer n;
                switch (toType) {
                    case BYTE: 
                    case SHORT: 
                    case CHAR: 
                    case INT: {
                        n = 136;
                        break block0;
                    }
                    case FLOAT: {
                        n = 137;
                        break block0;
                    }
                    case DOUBLE: {
                        n = 138;
                        break block0;
                    }
                }
                n = null;
                break;
            }
            case FLOAT: {
                Integer n;
                switch (toType) {
                    case BYTE: 
                    case SHORT: 
                    case CHAR: 
                    case INT: {
                        n = 139;
                        break block0;
                    }
                    case LONG: {
                        n = 140;
                        break block0;
                    }
                    case DOUBLE: {
                        n = 141;
                        break block0;
                    }
                }
                n = null;
                break;
            }
            case DOUBLE: {
                Integer n;
                switch (toType) {
                    case BYTE: 
                    case SHORT: 
                    case CHAR: 
                    case INT: {
                        n = 142;
                        break block0;
                    }
                    case LONG: {
                        n = 143;
                        break block0;
                    }
                    case FLOAT: {
                        n = 144;
                        break block0;
                    }
                }
                n = null;
                break;
            }
            default: {
                Integer n = opcode = null;
            }
        }
        if (opcode == null) {
            return;
        }
        insns.add(new InsnNode(opcode));
        switch (toType) {
            case BYTE: {
                insns.add(new InsnNode(145));
                break;
            }
            case SHORT: {
                insns.add(new InsnNode(147));
                break;
            }
            case CHAR: {
                insns.add(new InsnNode(146));
            }
        }
    }

    private static AbstractInsnNode findStartOfNullCheck(AbstractInsnNode insn, int classVersion) {
        if (insn.getOpcode() != 87) {
            return null;
        }
        if ((insn = AbstractInsnNodes.previousInstruction(insn)) == null || insn.getType() != 5) {
            return null;
        }
        MethodInsnNode methodInsn = (MethodInsnNode)insn;
        boolean isNullCheck = classVersion <= 52 ? methodInsn.getOpcode() == 182 && "getClass".equals(methodInsn.name) && "()Ljava/lang/Class;".equals(methodInsn.desc) : methodInsn.getOpcode() == 184 && "java/util/Objects".equals(methodInsn.owner) && "requireNonNull".equals(methodInsn.name) && "(Ljava/lang/Object;)Ljava/lang/Object;".equals(methodInsn.desc);
        return isNullCheck ? insn : null;
    }

    private static DataType getUnaryExpressionType(DataType operandType) {
        if (operandType == DataType.BYTE || operandType == DataType.SHORT || operandType == DataType.CHAR) {
            return DataType.INT;
        }
        return operandType;
    }

    private static DataType getExpressionType(final IReplacementGenerator.IContext context, Expression expression) {
        final DataType[] result = new DataType[]{null};
        expression.accept(new ExpressionVisitor(){

            @Override
            public void visitBinaryExpression(BinaryExpression binaryExpression) {
                binaryExpression.lhs.accept(this);
                DataType leftSide = result[0];
                binaryExpression.rhs.accept(this);
                DataType rightSide = result[0];
                result[0] = ExpressionEvaluator.getBinaryResultType(leftSide, rightSide);
            }

            @Override
            public void visitCastExpression(CastExpression castExpression) {
                result[0] = castExpression.castType;
            }

            @Override
            public void visitFieldExpression(FieldExpression fieldExpression) {
                result[0] = ExpressionGenerator.getFieldDataType(context, fieldExpression);
            }

            @Override
            public void visitLiteralExpression(LiteralExpression literalExpression) {
                Literal literal;
                Literal literal2 = literal = literalExpression.literal;
                Objects.requireNonNull(literal2);
                Literal literal3 = literal2;
                int n = 0;
                result[0] = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Literal.Integer.class, Literal.Long.class, Literal.Float.class, Literal.Double.class, Literal.String.class, Literal.Character.class}, (Object)literal3, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        Literal.Integer ignored = (Literal.Integer)literal3;
                        yield DataType.INT;
                    }
                    case 1 -> {
                        Literal.Long ignored = (Literal.Long)literal3;
                        yield DataType.LONG;
                    }
                    case 2 -> {
                        Literal.Float ignored = (Literal.Float)literal3;
                        yield DataType.FLOAT;
                    }
                    case 3 -> {
                        Literal.Double ignored = (Literal.Double)literal3;
                        yield DataType.DOUBLE;
                    }
                    case 4 -> {
                        Literal.String ignored = (Literal.String)literal3;
                        yield DataType.STRING;
                    }
                    case 5 -> {
                        Literal.Character ignored = (Literal.Character)literal3;
                        yield DataType.CHAR;
                    }
                };
            }

            @Override
            public void visitUnaryExpression(UnaryExpression unaryExpression) {
                super.visitUnaryExpression(unaryExpression);
                result[0] = ExpressionGenerator.getUnaryExpressionType(result[0]);
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object literalToObject(Literal literal) {
        Object object;
        Literal literal2 = literal;
        Objects.requireNonNull(literal2);
        Literal literal3 = literal2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Literal.Integer.class, Literal.Long.class, Literal.Float.class, Literal.Double.class, Literal.Character.class, Literal.String.class}, (Object)literal3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                int value;
                Literal.Integer integer = (Literal.Integer)literal3;
                try {
                    int n2;
                    value = n2 = integer.value();
                    int ignored = n2 = integer.radix();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                object = value;
                return object;
            }
            case 1: {
                long value;
                Literal.Long longVal = (Literal.Long)literal3;
                {
                    int n3;
                    long l;
                    value = l = longVal.value();
                    int ignored = n3 = longVal.radix();
                }
                object = value;
                return object;
            }
            case 2: {
                float value;
                Literal.Float float_ = (Literal.Float)literal3;
                {
                    float f;
                    value = f = float_.value();
                }
                object = Float.valueOf(value);
                return object;
            }
            case 3: {
                double value;
                Literal.Double double_ = (Literal.Double)literal3;
                {
                    double d;
                    value = d = double_.value();
                }
                object = value;
                return object;
            }
            case 4: {
                char value;
                Literal.Character character = (Literal.Character)literal3;
                {
                    char c;
                    value = c = character.value();
                }
                object = Character.valueOf(value);
                return object;
            }
            case 5: 
        }
        Literal.String string2 = (Literal.String)literal3;
        {
            String string;
            String value = string = string2.value();
            object = value;
        }
        return object;
    }

    private static Literal objectToLiteral(Object object) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Float.class, Double.class, Character.class, String.class}, (Object)object3, n)) {
            case 0 -> {
                Integer i = (Integer)object3;
                yield new Literal.Integer(i);
            }
            case 1 -> {
                Long l = (Long)object3;
                yield new Literal.Long(l);
            }
            case 2 -> {
                Float f = (Float)object3;
                yield new Literal.Float(f.floatValue());
            }
            case 3 -> {
                Double d = (Double)object3;
                yield new Literal.Double(d);
            }
            case 4 -> {
                Character c = (Character)object3;
                yield new Literal.Character(c.charValue());
            }
            case 5 -> {
                String s = (String)object3;
                yield new Literal.String(s);
            }
            default -> throw new AssertionError((Object)("Unexpected literal type: " + object.getClass().getName()));
        };
    }

    private static DataType getFieldDataType(IReplacementGenerator.IContext context, FieldExpression fieldExpression) {
        if (fieldExpression.fieldType != null) {
            return fieldExpression.fieldType;
        }
        IConstantResolver.ResolvedConstant resolvedConstant = context.getConstantResolver().resolveConstant(fieldExpression.className.replace('.', '/'), fieldExpression.fieldName);
        if (resolvedConstant == null) {
            throw new UnpickSyntaxException("Could not resolve constant " + fieldExpression.className + "." + fieldExpression.fieldName);
        }
        return DataTypeUtils.asmTypeToDataType(resolvedConstant.type());
    }

    @Nullable
    private static OuterClassReference getOuterClassReference(IReplacementGenerator.IContext context, ClassNode innerClass) {
        if (innerClass.fields == null || innerClass.fields.isEmpty()) {
            return null;
        }
        int slashIndex = innerClass.name.lastIndexOf(47);
        int dollarIndex = innerClass.name.lastIndexOf(36);
        if (dollarIndex <= slashIndex) {
            return null;
        }
        String outerClassName = innerClass.name.substring(0, dollarIndex);
        if (!innerClass.fields.getFirst().desc.equals("L" + outerClassName + ";")) {
            return null;
        }
        ClassNode outerClass = context.getClassResolver().resolveClass(outerClassName);
        if (outerClass == null) {
            return null;
        }
        boolean isInnerClassStatic = true;
        if (outerClass.innerClasses != null) {
            for (InnerClassNode innerClassNode : outerClass.innerClasses) {
                if (!innerClassNode.name.equals(innerClass.name)) continue;
                isInnerClassStatic = (innerClassNode.access & 8) != 0;
                break;
            }
        }
        if (isInnerClassStatic) {
            return null;
        }
        return new OuterClassReference(outerClass, innerClass.fields.getFirst());
    }

    @Nullable
    private static List<FieldNode> getThisReferenceChain(IReplacementGenerator.IContext context, FieldExpression fieldExpr) {
        String fieldOwner = fieldExpr.className.replace('.', '/');
        ClassNode clazz = context.getContainingClass();
        ArrayList<FieldNode> thisReferenceChain = new ArrayList<FieldNode>();
        while (!context.getInheritanceChecker().isAssignableFrom(fieldOwner, clazz.name)) {
            OuterClassReference outerClassRef = ExpressionGenerator.getOuterClassReference(context, clazz);
            if (outerClassRef == null) {
                return null;
            }
            thisReferenceChain.add(outerClassRef.outerThisReference);
            clazz = outerClassRef.outerClass;
        }
        return thisReferenceChain;
    }

    private record OuterClassReference(ClassNode outerClass, FieldNode outerThisReference) {
    }
}

