/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.classresolvers;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.api.classresolvers.IMemberChecker;
import daomephsta.unpick.impl.constantresolvers.ClasspathConstantResolver;
import daomephsta.unpick.impl.inheritancecheckers.ClasspathInheritanceChecker;
import daomephsta.unpick.impl.membercheckers.ClasspathMemberChecker;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

public class ClasspathClassResolver
implements IClassResolver {
    @Nullable
    private final ClassLoader classLoader;

    public ClasspathClassResolver(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ClassNode resolveClass(String internalName) {
        String resourceName = internalName + ".class";
        try (InputStream is = this.classLoader == null ? ClassLoader.getSystemResourceAsStream(resourceName) : this.classLoader.getResourceAsStream(resourceName);){
            if (is == null) {
                ClassNode classNode2 = null;
                return classNode2;
            }
            ClassReader classReader = new ClassReader(is);
            ClassNode classNode3 = new ClassNode();
            classReader.accept(classNode3, 2);
            ClassNode classNode = classNode3;
            return classNode;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public IConstantResolver asConstantResolver() {
        return new ClasspathConstantResolver(this.classLoader);
    }

    @Override
    public IInheritanceChecker asInheritanceChecker() {
        return new ClasspathInheritanceChecker(this.classLoader);
    }

    @Override
    public IMemberChecker asMemberChecker() {
        return new ClasspathMemberChecker(this.classLoader);
    }
}

