/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import daomephsta.unpick.api.constantgroupers.IReplacementGenerator;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.impl.DataTypeUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public class UnpickValue
implements IReplacementGenerator.IDataflowValue {
    private final Type dataType;
    private Set<Integer> parameterSources;
    private Set<IReplacementGenerator.IParameterUsage> parameterUsages;
    private Set<AbstractInsnNode> usages;
    private Set<DataType> typeInterpretations;

    public UnpickValue(Type dataType) {
        this.dataType = dataType;
        this.parameterSources = new HashSet<Integer>();
        this.parameterUsages = new HashSet<IReplacementGenerator.IParameterUsage>();
        this.usages = new HashSet<AbstractInsnNode>();
        this.typeInterpretations = new HashSet<DataType>();
        if (dataType != null) {
            this.addTypeInterpretationFromType(dataType);
        }
    }

    public UnpickValue(Type dataType, UnpickValue cloneOf) {
        this.dataType = dataType;
        this.parameterSources = cloneOf.getParameterSources();
        this.parameterUsages = cloneOf.getParameterUsages();
        this.usages = cloneOf.getUsages();
        this.typeInterpretations = cloneOf.getTypeInterpretations();
        if (dataType != null) {
            this.addTypeInterpretationFromType(dataType);
        }
    }

    @Override
    public int getSize() {
        return this.dataType == null ? 1 : this.dataType.getSize();
    }

    @Override
    public Type getDataType() {
        return this.dataType;
    }

    @Override
    public Set<Integer> getParameterSources() {
        return this.parameterSources;
    }

    @Override
    public Set<IReplacementGenerator.IParameterUsage> getParameterUsages() {
        return this.parameterUsages;
    }

    @Override
    public Set<AbstractInsnNode> getUsages() {
        return this.usages;
    }

    @Override
    public Set<DataType> getTypeInterpretations() {
        return this.typeInterpretations;
    }

    void setParameterSources(Set<Integer> parameterSources) {
        this.parameterSources = parameterSources;
    }

    void setParameterUsages(Set<IReplacementGenerator.IParameterUsage> parameterUsages) {
        this.parameterUsages = parameterUsages;
    }

    void setUsages(Set<AbstractInsnNode> usages) {
        this.usages = usages;
    }

    void setTypeInterpretations(Set<DataType> typeInterpretations) {
        this.typeInterpretations = typeInterpretations;
    }

    void addTypeInterpretationFromType(Type type) {
        DataType dataType = DataTypeUtils.asmTypeToDataType(type);
        if (dataType != null) {
            this.typeInterpretations.add(dataType);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnpickValue that = (UnpickValue)o;
        if (!Objects.equals(this.dataType, that.dataType)) {
            return false;
        }
        if (!this.parameterSources.equals(that.parameterSources)) {
            return false;
        }
        if (!this.parameterUsages.equals(that.parameterUsages)) {
            return false;
        }
        if (!this.usages.equals(that.usages)) {
            return false;
        }
        return this.typeInterpretations.equals(that.typeInterpretations);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.dataType);
        result = 31 * result + this.parameterSources.hashCode();
        result = 31 * result + this.parameterUsages.hashCode();
        result = 31 * result + this.usages.hashCode();
        result = 31 * result + this.typeInterpretations.hashCode();
        return result;
    }

    public static class ParameterUsage
    implements IReplacementGenerator.IParameterUsage {
        private final AbstractInsnNode methodInvocation;
        private final int paramIndex;

        public ParameterUsage(AbstractInsnNode methodInvocation, int paramIndex) {
            this.methodInvocation = methodInvocation;
            this.paramIndex = paramIndex;
        }

        @Override
        public AbstractInsnNode getMethodInvocation() {
            return this.methodInvocation;
        }

        @Override
        public int getParamIndex() {
            return this.paramIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterUsage that = (ParameterUsage)o;
            if (this.paramIndex != that.paramIndex) {
                return false;
            }
            return this.methodInvocation.equals(that.methodInvocation);
        }

        public int hashCode() {
            int result = this.methodInvocation.hashCode();
            result = 31 * result + this.paramIndex;
            return result;
        }

        public String toString() {
            return "MethodUsage{methodInvocation=" + String.valueOf(this.methodInvocation) + ", paramIndex=" + this.paramIndex + "}";
        }
    }
}

