/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.impl.UnpickValue;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;

public class UnpickInterpreter
extends Interpreter<UnpickValue>
implements Opcodes {
    private static final BasicValue BYTE_VALUE = new BasicValue(Type.BYTE_TYPE);
    private static final BasicValue SHORT_VALUE = new BasicValue(Type.SHORT_TYPE);
    private static final BasicValue CHAR_VALUE = new BasicValue(Type.CHAR_TYPE);
    private final MethodNode method;
    private final IInheritanceChecker inheritanceChecker;
    private final BasicInterpreter typeTracker = new BasicInterpreter(589824){

        @Override
        public BasicValue newValue(Type type) {
            if (type == null) {
                return super.newValue(null);
            }
            return switch (type.getSort()) {
                case 9, 10 -> new BasicValue(type);
                case 3 -> BYTE_VALUE;
                case 4 -> SHORT_VALUE;
                case 2 -> CHAR_VALUE;
                default -> super.newValue(type);
            };
        }

        @Override
        public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
            return switch (insn.getOpcode()) {
                case 145 -> BYTE_VALUE;
                case 147 -> SHORT_VALUE;
                case 146 -> CHAR_VALUE;
                default -> super.unaryOperation(insn, value);
            };
        }

        @Override
        public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
            return switch (insn.getOpcode()) {
                case 51 -> {
                    if (value1.getType().getDescriptor().equals("[Z")) {
                        yield super.binaryOperation(insn, value1, value2);
                    }
                    yield BYTE_VALUE;
                }
                case 53 -> SHORT_VALUE;
                case 52 -> CHAR_VALUE;
                default -> super.binaryOperation(insn, value1, value2);
            };
        }

        @Override
        public BasicValue merge(BasicValue value1, BasicValue value2) {
            boolean isReference2;
            boolean isIntegral2;
            if (value1.equals(value2)) {
                return value1;
            }
            Type type1 = value1.getType();
            Type type2 = value2.getType();
            if (type1 == null || type2 == null) {
                return BasicValue.UNINITIALIZED_VALUE;
            }
            boolean isIntegral1 = type1.getSort() >= 2 && type1.getSort() <= 5;
            boolean bl = isIntegral2 = type2.getSort() >= 2 && type2.getSort() <= 5;
            if (isIntegral1 && isIntegral2) {
                if (type1 == Type.CHAR_TYPE || type2 == Type.CHAR_TYPE) {
                    return BasicValue.INT_VALUE;
                }
                return type1.getSort() > type2.getSort() ? value1 : value2;
            }
            boolean isReference1 = type1.getSort() == 10 || type1.getSort() == 9;
            boolean bl2 = isReference2 = type2.getSort() == 10 || type2.getSort() == 9;
            if (isReference1 && isReference2) {
                if (type1.equals(NULL_TYPE)) {
                    return value2;
                }
                if (type2.equals(NULL_TYPE)) {
                    return value1;
                }
                if (this.isAssignableFrom(type1, type2)) {
                    return value1;
                }
                if (this.isAssignableFrom(type2, type1)) {
                    return value2;
                }
                int numDimensions = 0;
                if (type1.getSort() == 9 && type2.getSort() == 9 && type1.getDimensions() == type2.getDimensions() && type1.getElementType().getSort() == 10 && type2.getElementType().getSort() == 10) {
                    numDimensions = type1.getDimensions();
                    type1 = type1.getElementType();
                    type2 = type2.getElementType();
                }
                do {
                    if (type1 != null && !this.isInterface(type1)) continue;
                    return this.newArrayValue(Type.getObjectType("java/lang/Object"), numDimensions);
                } while ((type1 = this.getSuperClass(type1)) == null || !this.isAssignableFrom(type1, type2));
                return this.newArrayValue(type1, numDimensions);
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }

        private boolean isAssignableFrom(Type type1, Type type2) {
            if (type1.equals(type2)) {
                return true;
            }
            if (type1.getSort() != 10 && type1.getSort() != 9 || type2.getSort() != 10 && type2.getSort() != 9) {
                return false;
            }
            if (type1.getInternalName().equals("java/lang/Object")) {
                return true;
            }
            if (type2.getSort() == 9) {
                int dimensions2;
                if (type1.getSort() == 10) {
                    return type1.getInternalName().equals("java/lang/Object");
                }
                int dimensions1 = type1.getDimensions();
                if (dimensions1 < (dimensions2 = type2.getDimensions())) {
                    return type1.getElementType().getDescriptor().equals("Ljava/lang/Object;");
                }
                if (dimensions1 > dimensions2) {
                    return false;
                }
                return this.isAssignableFrom(type1.getElementType(), type2.getElementType());
            }
            if (type1.getSort() == 9) {
                return false;
            }
            return UnpickInterpreter.this.inheritanceChecker.isAssignableFrom(type1.getInternalName(), type2.getInternalName());
        }

        @Nullable
        private Type getSuperClass(Type type) {
            if (type.getSort() == 9) {
                return Type.getObjectType("java/lang/Object");
            }
            if ("java/lang/Object".equals(type.getInternalName())) {
                return null;
            }
            IInheritanceChecker.ClassInfo classInfo = UnpickInterpreter.this.inheritanceChecker.getClassInfo(type.getInternalName());
            if (classInfo == null) {
                return Type.getObjectType("java/lang/Object");
            }
            return Type.getObjectType(Objects.requireNonNull(classInfo.superClass(), "returned null for non-Object superclass"));
        }

        private boolean isInterface(Type type) {
            if (type.getSort() == 10) {
                return false;
            }
            IInheritanceChecker.ClassInfo classInfo = UnpickInterpreter.this.inheritanceChecker.getClassInfo(type.getInternalName());
            return classInfo != null && classInfo.isInterface();
        }

        private BasicValue newArrayValue(Type type, int dimensions) {
            if (dimensions == 0) {
                return this.newValue(type);
            }
            StringBuilder desc = new StringBuilder(type.getDescriptor().length() + dimensions);
            for (int i = 0; i < dimensions; ++i) {
                desc.append('[');
            }
            desc.append(type.getDescriptor());
            return this.newValue(Type.getType(desc.toString()));
        }
    };

    public UnpickInterpreter(MethodNode method, IInheritanceChecker inheritanceChecker) {
        super(589824);
        this.method = method;
        this.inheritanceChecker = inheritanceChecker;
    }

    @Override
    public UnpickValue newParameterValue(boolean isInstanceMethod, int local, Type type) {
        UnpickValue value = this.newValue(type);
        if (isInstanceMethod && local == 0) {
            return value;
        }
        int localIndex = isInstanceMethod ? 1 : 0;
        int paramIndex = 0;
        for (Type argument : Type.getArgumentTypes(this.method.desc)) {
            if (localIndex == local) break;
            localIndex += argument.getSize();
            ++paramIndex;
        }
        value.getParameterSources().add(paramIndex);
        return value;
    }

    @Override
    public UnpickValue newValue(Type type) {
        if (type == Type.VOID_TYPE) {
            return null;
        }
        return new UnpickValue(UnpickInterpreter.getType(this.typeTracker.newValue(type)));
    }

    @Override
    public UnpickValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        UnpickValue value = new UnpickValue(UnpickInterpreter.getType(this.typeTracker.newOperation(insn)));
        value.getUsages().add(insn);
        return value;
    }

    @Override
    public UnpickValue copyOperation(AbstractInsnNode insn, UnpickValue value) throws AnalyzerException {
        Type type = UnpickInterpreter.getType(this.typeTracker.copyOperation(insn, this.typeTracker.newValue(value.getDataType())));
        return new UnpickValue(type, value);
    }

    @Override
    public UnpickValue unaryOperation(AbstractInsnNode insn, UnpickValue value) throws AnalyzerException {
        UnpickValue newValue;
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 145: 
            case 146: 
            case 147: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 188: 
            case 189: {
                value.getTypeInterpretations().add(DataType.INT);
                break;
            }
            case 117: 
            case 136: 
            case 137: 
            case 138: {
                value.getTypeInterpretations().add(DataType.LONG);
                break;
            }
            case 118: 
            case 139: 
            case 140: 
            case 141: {
                value.getTypeInterpretations().add(DataType.FLOAT);
                break;
            }
            case 119: 
            case 142: 
            case 143: 
            case 144: {
                value.getTypeInterpretations().add(DataType.DOUBLE);
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                value.addTypeInterpretationFromType(Type.getReturnType(this.method.desc));
                break;
            }
            case 179: {
                value.addTypeInterpretationFromType(Type.getType(((FieldInsnNode)insn).desc));
                break;
            }
            case 192: {
                value.addTypeInterpretationFromType(Type.getObjectType(((TypeInsnNode)insn).desc));
            }
        }
        boolean inputIsSameValueAsOutput = switch (insn.getOpcode()) {
            case 116, 117, 118, 119, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 172, 173, 174, 175, 176, 192 -> true;
            default -> false;
        };
        Type type = UnpickInterpreter.getType(this.typeTracker.unaryOperation(insn, this.typeTracker.newValue(value.getDataType())));
        UnpickValue unpickValue = newValue = inputIsSameValueAsOutput ? new UnpickValue(type, value) : new UnpickValue(type);
        if (insn.getType() == 4 || insn.getType() == 7 || insn.getOpcode() >= 172 && insn.getOpcode() <= 177) {
            newValue.getUsages().add(insn);
        }
        return newValue;
    }

    @Override
    public UnpickValue binaryOperation(AbstractInsnNode insn, UnpickValue value1, UnpickValue value2) throws AnalyzerException {
        Type type = UnpickInterpreter.getType(this.typeTracker.binaryOperation(insn, this.typeTracker.newValue(value1.getDataType()), this.typeTracker.newValue(value2.getDataType())));
        return switch (insn.getOpcode()) {
            case 46, 47, 48, 49, 50, 51, 52, 53 -> {
                value2.getTypeInterpretations().add(DataType.INT);
                yield new UnpickValue(type);
            }
            case 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 126, 127, 128, 129, 130, 131 -> new UnpickValue(type, this.merge(value1, value2));
            case 120, 121, 122, 123, 124, 125 -> {
                value2.getTypeInterpretations().add(DataType.INT);
                yield new UnpickValue(type, value1);
            }
            case 148, 149, 150, 151, 152, 159, 160, 161, 162, 163, 164, 165, 166 -> {
                this.merge(value1, value2);
                yield new UnpickValue(type);
            }
            case 181 -> {
                value2.getUsages().add(insn);
                value2.addTypeInterpretationFromType(Type.getType(((FieldInsnNode)insn).desc));
                yield new UnpickValue(type);
            }
            default -> throw new IllegalArgumentException("Unrecognized insn: " + insn.getOpcode());
        };
    }

    @Override
    public UnpickValue ternaryOperation(AbstractInsnNode insn, UnpickValue value1, UnpickValue value2, UnpickValue value3) throws AnalyzerException {
        value2.getTypeInterpretations().add(DataType.INT);
        switch (insn.getOpcode()) {
            case 84: {
                if (value1.getDataType().getDescriptor().equals("[Z")) break;
                value3.getTypeInterpretations().add(DataType.BYTE);
                break;
            }
            case 86: {
                value3.getTypeInterpretations().add(DataType.SHORT);
                break;
            }
            case 85: {
                value3.getTypeInterpretations().add(DataType.CHAR);
                break;
            }
            case 79: {
                value3.getTypeInterpretations().add(DataType.INT);
                break;
            }
            case 80: {
                value3.getTypeInterpretations().add(DataType.LONG);
                break;
            }
            case 81: {
                value3.getTypeInterpretations().add(DataType.FLOAT);
                break;
            }
            case 82: {
                value3.getTypeInterpretations().add(DataType.DOUBLE);
                break;
            }
            case 83: {
                if (value1.getDataType().getSort() != 9) break;
                value3.addTypeInterpretationFromType(Type.getType(value1.getDataType().getDescriptor().substring(1)));
            }
        }
        Type type = UnpickInterpreter.getType(this.typeTracker.ternaryOperation(insn, this.typeTracker.newValue(value1.getDataType()), this.typeTracker.newValue(value2.getDataType()), this.typeTracker.newValue(value3.getDataType())));
        return new UnpickValue(type);
    }

    @Override
    public UnpickValue naryOperation(AbstractInsnNode insn, List<? extends UnpickValue> values) throws AnalyzerException {
        int i;
        Type type = UnpickInterpreter.getType((BasicValue)this.typeTracker.naryOperation(insn, values.stream().map(value -> this.typeTracker.newValue(value.getDataType())).collect(Collectors.toList())));
        if (insn.getOpcode() == 197) {
            return new UnpickValue(type);
        }
        boolean hasThis = insn.getOpcode() != 184 && insn.getOpcode() != 186;
        String desc = insn.getOpcode() == 186 ? ((InvokeDynamicInsnNode)insn).desc : ((MethodInsnNode)insn).desc;
        Type[] argumentTypes = Type.getArgumentTypes(desc);
        int n = i = hasThis ? 1 : 0;
        while (i < values.size()) {
            int paramIndex = hasThis ? i - 1 : i;
            values.get(i).getParameterUsages().add(new UnpickValue.ParameterUsage(insn, paramIndex));
            values.get(i).addTypeInterpretationFromType(argumentTypes[paramIndex]);
            ++i;
        }
        UnpickValue value2 = new UnpickValue(type);
        value2.getUsages().add(insn);
        return value2;
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, UnpickValue value, UnpickValue expected) {
    }

    @Override
    public UnpickValue merge(UnpickValue value1, UnpickValue value2) {
        value1.getParameterSources().addAll(value2.getParameterSources());
        value1.getParameterUsages().addAll(value2.getParameterUsages());
        value1.getUsages().addAll(value2.getUsages());
        value1.getTypeInterpretations().addAll(value2.getTypeInterpretations());
        value2.setParameterSources(value1.getParameterSources());
        value2.setParameterUsages(value1.getParameterUsages());
        value2.setUsages(value1.getUsages());
        value2.setTypeInterpretations(value1.getTypeInterpretations());
        Type type = this.typeTracker.merge(this.typeTracker.newValue(value1.getDataType()), this.typeTracker.newValue(value2.getDataType())).getType();
        return new UnpickValue(type, value1);
    }

    private static Type getType(BasicValue value) {
        return value == null ? null : value.getType();
    }
}

