/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import java.lang.runtime.SwitchBootstraps;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

public class InstructionFactory
implements Opcodes {
    public static AbstractInsnNode pushValue(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Float.class, Number.class, Character.class, Boolean.class, String.class, Type.class}, (Object)object, n)) {
            case 0 -> {
                Long l = (Long)object;
                yield InstructionFactory.pushLong(l);
            }
            case 1 -> {
                Double d = (Double)object;
                yield InstructionFactory.pushDouble(d);
            }
            case 2 -> {
                Float f = (Float)object;
                yield InstructionFactory.pushFloat(f.floatValue());
            }
            case 3 -> {
                Number n = (Number)object;
                yield InstructionFactory.pushInt(n.intValue());
            }
            case 4 -> {
                Character c = (Character)object;
                yield InstructionFactory.pushChar(c.charValue());
            }
            case 5 -> {
                Boolean b = (Boolean)object;
                yield InstructionFactory.pushBoolean(b);
            }
            case 6 -> {
                String s = (String)object;
                yield InstructionFactory.pushString(s);
            }
            case 7 -> {
                Type t = (Type)object;
                yield InstructionFactory.pushTypeReference(t);
            }
            case -1 -> new InsnNode(1);
            default -> throw new UnsupportedOperationException("Pushing reference types is not supported");
        };
    }

    public static AbstractInsnNode pushBoolean(boolean bool) {
        return new InsnNode(bool ? 4 : 3);
    }

    public static AbstractInsnNode pushChar(char c) {
        return InstructionFactory.pushInt(c);
    }

    public static AbstractInsnNode pushInt(int i) {
        if (i >= -1 && i <= 5) {
            return new InsnNode(3 + i);
        }
        if (i >= -128 && i <= 127) {
            return new IntInsnNode(16, i);
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return new IntInsnNode(17, i);
        }
        return new LdcInsnNode((Object)i);
    }

    public static AbstractInsnNode pushLong(long l) {
        if (l == 0L) {
            return new InsnNode(9);
        }
        if (l == 1L) {
            return new InsnNode(10);
        }
        return new LdcInsnNode(l);
    }

    public static AbstractInsnNode pushFloat(float f) {
        if (f == 0.0f) {
            return new InsnNode(11);
        }
        if (f == 1.0f) {
            return new InsnNode(12);
        }
        if (f == 2.0f) {
            return new InsnNode(13);
        }
        return new LdcInsnNode(Float.valueOf(f));
    }

    public static AbstractInsnNode pushDouble(double d) {
        if (d == 0.0) {
            return new InsnNode(14);
        }
        if (d == 1.0) {
            return new InsnNode(15);
        }
        return new LdcInsnNode(d);
    }

    public static AbstractInsnNode pushString(String s2) {
        return new LdcInsnNode(s2);
    }

    public static AbstractInsnNode pushTypeReference(Type type) {
        return new LdcInsnNode(type);
    }
}

