/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public final class DataTypeUtils {
    private DataTypeUtils() {
    }

    public static DataType asmTypeToDataType(Type type) {
        return switch (type.getSort()) {
            case 3 -> DataType.BYTE;
            case 4 -> DataType.SHORT;
            case 5 -> DataType.INT;
            case 7 -> DataType.LONG;
            case 6 -> DataType.FLOAT;
            case 8 -> DataType.DOUBLE;
            case 2 -> DataType.CHAR;
            case 10 -> {
                switch (type.getInternalName()) {
                    case "java/lang/String": {
                        yield DataType.STRING;
                    }
                    case "java/lang/Class": {
                        yield DataType.CLASS;
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    public static String getDescriptor(DataType dataType) {
        return switch (dataType) {
            default -> throw new MatchException(null, null);
            case DataType.BYTE -> "B";
            case DataType.SHORT -> "S";
            case DataType.INT -> "I";
            case DataType.LONG -> "J";
            case DataType.FLOAT -> "F";
            case DataType.DOUBLE -> "D";
            case DataType.CHAR -> "C";
            case DataType.STRING -> "Ljava/lang/String;";
            case DataType.CLASS -> "Ljava/lang/Class;";
        };
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static DataType getDataType(@Nullable Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, Type.class}, (Object)object, n)) {
            case 0 -> {
                Byte ignored = (Byte)object;
                yield DataType.BYTE;
            }
            case 1 -> {
                Short ignored = (Short)object;
                yield DataType.SHORT;
            }
            case 2 -> {
                Integer ignored = (Integer)object;
                yield DataType.INT;
            }
            case 3 -> {
                Long ignored = (Long)object;
                yield DataType.LONG;
            }
            case 4 -> {
                Float ignored = (Float)object;
                yield DataType.FLOAT;
            }
            case 5 -> {
                Double ignored = (Double)object;
                yield DataType.DOUBLE;
            }
            case 6 -> {
                Character ignored = (Character)object;
                yield DataType.CHAR;
            }
            case 7 -> {
                String ignored = (String)object;
                yield DataType.STRING;
            }
            case 8 -> {
                Type ignored = (Type)object;
                yield DataType.CLASS;
            }
            case -1 -> null;
            default -> throw new AssertionError((Object)("Invalid constant data type: " + value.getClass().getName()));
        };
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Object cast(@Nullable Object value, @Nullable DataType dataType) {
        if (value == null) {
            if (DataTypeUtils.isPrimitive(dataType)) {
                throw new UnpickSyntaxException("Cannot cast null to " + DataTypeUtils.getTypeName(dataType));
            }
            return null;
        }
        Object result = DataTypeUtils.tryCast(value, dataType);
        if (result == null) {
            throw new UnpickSyntaxException("Cannot cast " + String.valueOf(value) + " to " + DataTypeUtils.getTypeName(dataType));
        }
        return result;
    }

    @Nullable
    public static Object tryCast(@Nullable Object value, @Nullable DataType dataType) {
        DataType dataType2 = dataType;
        int n2 = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"BYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "CHAR", "STRING", "CLASS"}, (DataType)dataType2, n2)) {
            default -> throw new MatchException(null, null);
            case 0 -> DataTypeUtils.tryCastToNumber(value, Number::byteValue);
            case 1 -> DataTypeUtils.tryCastToNumber(value, Number::shortValue);
            case 2 -> DataTypeUtils.tryCastToNumber(value, Number::intValue);
            case 3 -> DataTypeUtils.tryCastToNumber(value, Number::longValue);
            case 4 -> DataTypeUtils.tryCastToNumber(value, Number::floatValue);
            case 5 -> DataTypeUtils.tryCastToNumber(value, Number::doubleValue);
            case 6 -> DataTypeUtils.tryCastToNumber(value, n -> Character.valueOf((char)n.intValue()));
            case 7 -> {
                if (value instanceof String) {
                    yield value;
                }
                yield null;
            }
            case 8 -> {
                if (value instanceof Type) {
                    yield value;
                }
                yield null;
            }
            case -1 -> value instanceof String || value instanceof Type ? value : null;
        };
    }

    @Nullable
    private static Object tryCastToNumber(@Nullable Object value, Function<Number, Object> castFunction) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Character.class, Number.class}, (Object)object, n)) {
            case 0 -> {
                Character c = (Character)object;
                yield castFunction.apply((int)c.charValue());
            }
            case 1 -> {
                Number n = (Number)object;
                yield castFunction.apply(n);
            }
            default -> null;
        };
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Object castExact(@Nullable Object value, @Nullable DataType dataType) {
        if (value == null) {
            if (DataTypeUtils.isPrimitive(dataType)) {
                throw new UnpickSyntaxException("Cannot cast null exactly to " + DataTypeUtils.getTypeName(dataType));
            }
            return null;
        }
        Object result = DataTypeUtils.tryCastExact(value, dataType);
        if (result == null) {
            throw new UnpickSyntaxException("Cannot cast " + String.valueOf(value) + " exactly to " + DataTypeUtils.getTypeName(dataType));
        }
        return result;
    }

    @Nullable
    public static Object tryCastExact(@Nullable Object value, @Nullable DataType dataType) {
        DataType dataType2 = dataType;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"BYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "CHAR", "STRING", "CLASS"}, (DataType)dataType2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> DataTypeUtils.tryCastToDoubleFittingNumberExact(value, Number::byteValue);
            case 1 -> DataTypeUtils.tryCastToDoubleFittingNumberExact(value, Number::shortValue);
            case 2 -> DataTypeUtils.tryCastToDoubleFittingNumberExact(value, Number::intValue);
            case 3 -> {
                Object var4_4 = value;
                int var5_6 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, Double.class, Number.class}, (Object)var4_4, var5_6)) {
                    case 0: {
                        Float f = (Float)var4_4;
                        if ((float)f.longValue() == f.floatValue()) {
                            yield f.longValue();
                        }
                        yield null;
                    }
                    case 1: {
                        Double d = (Double)var4_4;
                        if ((double)d.longValue() == d) {
                            yield d.longValue();
                        }
                        yield null;
                    }
                    case 2: {
                        Number n = (Number)var4_4;
                        yield n.longValue();
                    }
                }
                yield null;
            }
            case 4 -> DataTypeUtils.tryCastToDoubleFittingNumberExact(value, Number::floatValue);
            case 5 -> DataTypeUtils.tryCastToDoubleFittingNumberExact(value, Number::doubleValue);
            case 6 -> {
                Integer result = DataTypeUtils.tryCastToDoubleFittingNumberExact(value, Number::intValue);
                if (result == null) {
                    yield null;
                }
                yield Character.valueOf((char)result.intValue());
            }
            case 7 -> {
                if (value instanceof String) {
                    yield value;
                }
                yield null;
            }
            case 8 -> {
                if (value instanceof Type) {
                    yield value;
                }
                yield null;
            }
            case -1 -> value instanceof String || value instanceof Type ? value : null;
        };
    }

    private static <T extends Number> T tryCastToDoubleFittingNumberExact(@Nullable Object value, Function<Number, T> castFunction) {
        Object object = value;
        int n = 0;
        return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Character.class, Number.class}, (Object)object, n)) {
            case 0 -> {
                Character c = (Character)object;
                Number result = (Number)castFunction.apply((int)c.charValue());
                yield result.intValue() == c.charValue() ? result : null;
            }
            case 1 -> {
                Number n = (Number)object;
                Number result = (Number)castFunction.apply(n);
                yield result.doubleValue() == n.doubleValue() ? result : null;
            }
            default -> null;
        });
    }

    public static boolean isPrimitive(@Nullable DataType dataType) {
        return dataType != DataType.STRING && dataType != DataType.CLASS && dataType != null;
    }

    public static boolean isAssignable(@Nullable DataType lhs, @Nullable DataType rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null) {
            return false;
        }
        if (rhs == null) {
            return !DataTypeUtils.isPrimitive(lhs);
        }
        if (!DataTypeUtils.isPrimitive(lhs) || !DataTypeUtils.isPrimitive(rhs)) {
            return false;
        }
        if (lhs == DataType.CHAR) {
            return false;
        }
        if (rhs == DataType.CHAR) {
            return lhs.ordinal() >= DataType.INT.ordinal();
        }
        return lhs.ordinal() >= rhs.ordinal();
    }

    public static DataType getCommonSuperType(DataType type1, DataType type2) {
        if (DataTypeUtils.isAssignable(type1, type2)) {
            return type1;
        }
        if (DataTypeUtils.isAssignable(type2, type1)) {
            return type2;
        }
        if (DataTypeUtils.isPrimitive(type1) && DataTypeUtils.isPrimitive(type2)) {
            return DataType.INT;
        }
        throw new UnpickSyntaxException("Cannot find common super type of " + DataTypeUtils.getTypeName(type1) + " and " + DataTypeUtils.getTypeName(type2));
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static DataType widenNarrowTypes(@Nullable DataType dataType) {
        DataType dataType2 = dataType;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"BYTE", "SHORT", "CHAR"}, (DataType)dataType2, n)) {
            case 0, 1, 2 -> DataType.INT;
            default -> dataType;
        };
    }

    public static String getTypeName(@Nullable DataType dataType) {
        DataType dataType2 = dataType;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"STRING", "CLASS"}, (DataType)dataType2, n)) {
            case 0 -> "String";
            case 1 -> "Class";
            case -1 -> "null";
            default -> dataType.name().toLowerCase(Locale.ROOT);
        };
    }
}

