/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import daomephsta.unpick.impl.Utils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

public class AbstractInsnNodes
implements Opcodes {
    public static boolean hasLiteralValue(AbstractInsnNode insn) {
        return insn.getOpcode() >= 1 && insn.getOpcode() <= 18;
    }

    @Nullable
    public static Object getLiteralValue(AbstractInsnNode insn) {
        return switch (insn.getOpcode()) {
            case 1 -> null;
            case 2, 3, 4, 5, 6, 7, 8 -> insn.getOpcode() - 3;
            case 9, 10 -> (long)insn.getOpcode() - 9L;
            case 11, 12, 13 -> Float.valueOf((float)insn.getOpcode() - 11.0f);
            case 14, 15 -> (double)insn.getOpcode() - 14.0;
            case 16, 17 -> ((IntInsnNode)insn).operand;
            case 18 -> ((LdcInsnNode)insn).cst;
            default -> throw new UnsupportedOperationException("No value retrieval method programmed for " + Utils.visitableToString(insn::accept).trim());
        };
    }

    @Nullable
    public static AbstractInsnNode previousInstruction(AbstractInsnNode insn) {
        while ((insn = insn.getPrevious()) != null) {
            if (insn.getOpcode() < 0) continue;
            return insn;
        }
        return null;
    }

    @Nullable
    public static AbstractInsnNode nextInstruction(AbstractInsnNode insn) {
        while ((insn = insn.getNext()) != null) {
            if (insn.getOpcode() < 0) continue;
            return insn;
        }
        return null;
    }
}

