/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.constantmappers.datadriven.parser.v2;

import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UnpickV2Reader
implements Closeable {
    private static final Pattern WHITESPACE_SPLITTER = Pattern.compile("\\s");
    private final Reader definitionsReader;
    private TargetMethodDefinitionVisitor lastTargetMethodVisitor = null;
    private static final Set<String> TARGET_METHOD_ARGS = Stream.of("param", "return").collect(Collectors.toSet());
    private static final TargetMethodDefinitionVisitor DEFAULT = new TargetMethodDefinitionVisitor(){};

    public UnpickV2Reader(InputStream definitionsStream) {
        this(new InputStreamReader(definitionsStream));
    }

    public UnpickV2Reader(Reader definitionsReader) {
        this.definitionsReader = definitionsReader;
    }

    public void accept(Visitor visitor) {
        try (LineNumberReader reader = new LineNumberReader(this.definitionsReader);){
            Iterator lineTokensIter = reader.lines().skip(1L).map(s2 -> this.stripComment(s2.trim())).filter(s2 -> !s2.isEmpty()).map(l -> (String[])Arrays.stream(WHITESPACE_SPLITTER.split((CharSequence)l)).filter(s2 -> !s2.isEmpty()).toArray(String[]::new)).iterator();
            visitor.startVisit();
            block19: while (lineTokensIter.hasNext()) {
                Object[] tokens = (String[])lineTokensIter.next();
                visitor.visitLineNumber(reader.getLineNumber());
                if (tokens[0].equals("target_method")) {
                    this.visitTargetMethodDefinition(visitor, (String[])tokens, reader.getLineNumber());
                    continue;
                }
                if (this.lastTargetMethodVisitor != null && !TARGET_METHOD_ARGS.contains(tokens[0])) {
                    this.lastTargetMethodVisitor.endVisit();
                    this.lastTargetMethodVisitor = null;
                }
                switch (tokens[0]) {
                    case "constant": {
                        this.visitSimpleConstantDefinition(visitor, (String[])tokens, reader.getLineNumber());
                        continue block19;
                    }
                    case "flag": {
                        this.visitFlagConstantDefinition(visitor, (String[])tokens, reader.getLineNumber());
                        continue block19;
                    }
                    case "param": {
                        this.visitParameterConstantGroupDefinition(visitor, (String[])tokens, reader.getLineNumber());
                        continue block19;
                    }
                    case "return": {
                        this.visitReturnConstantGroupDefinition(visitor, (String[])tokens, reader.getLineNumber());
                        continue block19;
                    }
                }
                throw new UnpickSyntaxException("\nUnknown start token Tokens: " + Arrays.toString(tokens));
            }
            if (this.lastTargetMethodVisitor != null) {
                this.lastTargetMethodVisitor.endVisit();
                this.lastTargetMethodVisitor = null;
            }
            visitor.endVisit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void visitParameterConstantGroupDefinition(Visitor visitor, String[] tokens, int lineNumber) {
        if (this.lastTargetMethodVisitor == null) {
            throw new UnpickSyntaxException(lineNumber, "Invalid parameter constant group definition, not part of target method definition");
        }
        if (tokens.length != 3) {
            throw new UnpickSyntaxException(lineNumber, "Unexpected token count. Expected 3. Found " + tokens.length);
        }
        try {
            this.lastTargetMethodVisitor.visitParameterGroupDefinition(Integer.parseInt(tokens[1]), tokens[2]);
        }
        catch (NumberFormatException e) {
            throw new UnpickSyntaxException(lineNumber, "Could not parse " + tokens[1] + " as an integer");
        }
    }

    private void visitReturnConstantGroupDefinition(Visitor visitor, String[] tokens, int lineNumber) {
        if (this.lastTargetMethodVisitor == null) {
            throw new UnpickSyntaxException(lineNumber, "Invalid return constant group definition, not part of target method definition");
        }
        if (tokens.length != 2) {
            throw new UnpickSyntaxException(lineNumber, "Unexpected token count. Expected 2. Found " + tokens.length);
        }
        this.lastTargetMethodVisitor.visitReturnGroupDefinition(tokens[1]);
    }

    private void visitSimpleConstantDefinition(Visitor visitor, String[] tokens, int lineNumber) {
        if (tokens.length != 4 && tokens.length != 6) {
            throw new UnpickSyntaxException(lineNumber, "Unexpected token count. Expected 4 or 6. Found " + tokens.length);
        }
        if (tokens.length > 4) {
            visitor.visitSimpleConstantDefinition(tokens[1], tokens[2], tokens[3], tokens[4], tokens[5]);
        } else {
            visitor.visitSimpleConstantDefinition(tokens[1], tokens[2], tokens[3], null, null);
        }
    }

    private void visitFlagConstantDefinition(Visitor visitor, String[] tokens, int lineNumber) {
        if (tokens.length != 4 && tokens.length != 6) {
            throw new UnpickSyntaxException(lineNumber, "Unexpected token count. Expected 4 or 6. Found " + tokens.length);
        }
        if (tokens.length > 4) {
            visitor.visitFlagConstantDefinition(tokens[1], tokens[2], tokens[3], tokens[4], tokens[5]);
        } else {
            visitor.visitFlagConstantDefinition(tokens[1], tokens[2], tokens[3], null, null);
        }
    }

    private void visitTargetMethodDefinition(Visitor visitor, String[] tokens, int lineNumber) {
        if (tokens.length != 4) {
            throw new UnpickSyntaxException(lineNumber, "Unexpected token count. Expected 4. Found " + tokens.length);
        }
        if (this.lastTargetMethodVisitor != null) {
            this.lastTargetMethodVisitor.endVisit();
        }
        this.lastTargetMethodVisitor = visitor.visitTargetMethodDefinition(tokens[1], tokens[2], tokens[3]);
        if (this.lastTargetMethodVisitor == null) {
            this.lastTargetMethodVisitor = DEFAULT;
        }
    }

    private String stripComment(String in) {
        int c = in.indexOf(35);
        return c == -1 ? in : in.substring(0, c);
    }

    @Override
    public void close() throws IOException {
        this.definitionsReader.close();
    }

    public static interface TargetMethodDefinitionVisitor {
        default public void visitParameterGroupDefinition(int parameterIndex, String group) {
        }

        default public void visitReturnGroupDefinition(String group) {
        }

        default public void endVisit() {
        }
    }

    public static interface Visitor {
        default public void startVisit() {
        }

        default public void visitLineNumber(int lineNumber) {
        }

        default public void visitSimpleConstantDefinition(String group, String owner, String name, String value, String descriptor) {
        }

        default public void visitFlagConstantDefinition(String group, String owner, String name, String value, String descriptor) {
        }

        default public TargetMethodDefinitionVisitor visitTargetMethodDefinition(String owner, String name, String descriptor) {
            return DEFAULT;
        }

        default public void endVisit() {
        }
    }
}

