/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.api.classresolvers;

import daomephsta.unpick.impl.Utils;
import daomephsta.unpick.impl.membercheckers.ChainMemberChecker;
import daomephsta.unpick.impl.membercheckers.MemberInfoImpl;
import daomephsta.unpick.impl.membercheckers.ParameterInfoImpl;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface IMemberChecker {
    @Nullable(value="if the class doesn't exist")
    public @Nullable(value="if the class doesn't exist") List<MemberInfo> getFields(String var1);

    @Nullable(value="if the class doesn't exist")
    public @Nullable(value="if the class doesn't exist") List<MemberInfo> getMethods(String var1);

    @Nullable
    default public MemberInfo getField(String className, String fieldName, String fieldDesc) {
        List<MemberInfo> fields = this.getFields(className);
        if (fields == null) {
            return null;
        }
        for (MemberInfo memberInfo : fields) {
            if (!memberInfo.name().equals(fieldName) || !memberInfo.desc().equals(fieldDesc)) continue;
            return memberInfo;
        }
        return null;
    }

    @Nullable
    default public MemberInfo getMethod(String className, String methodName, String methodDesc) {
        List<MemberInfo> methods = this.getMethods(className);
        if (methods == null) {
            return null;
        }
        for (MemberInfo memberInfo : methods) {
            if (!memberInfo.name().equals(methodName) || !memberInfo.desc().equals(methodDesc)) continue;
            return memberInfo;
        }
        return null;
    }

    @Nullable
    public ParameterInfo getParameter(String var1, String var2, String var3, int var4);

    default public IMemberChecker chain(IMemberChecker ... others) {
        return new ChainMemberChecker(Utils.prepend(this, others));
    }

    @ApiStatus.NonExtendable
    public static interface MemberInfo {
        public int access();

        public String name();

        public String desc();

        public List<String> annotations();

        public static MemberInfo create(int access, String name, String desc) {
            return new MemberInfoImpl(access, name, desc, List.of());
        }

        public MemberInfo withAnnotations(List<String> var1);
    }

    @ApiStatus.NonExtendable
    public static interface ParameterInfo {
        public int access();

        public List<String> annotations();

        public static ParameterInfo create(int access) {
            return new ParameterInfoImpl(access, List.of());
        }

        public ParameterInfo withAnnotations(List<String> var1);
    }
}

