/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.api.classresolvers;

import daomephsta.unpick.impl.Utils;
import daomephsta.unpick.impl.inheritancecheckers.ChainInheritanceChecker;
import org.jetbrains.annotations.Nullable;

public interface IInheritanceChecker {
    @Nullable
    public ClassInfo getClassInfo(String var1);

    default public boolean isAssignableFrom(String type1, String type2) {
        if ("java/lang/Object".equals(type1)) {
            return true;
        }
        while (type2 != null) {
            if (type1.equals(type2)) {
                return true;
            }
            ClassInfo classInfo = this.getClassInfo(type2);
            if (classInfo == null) {
                return false;
            }
            for (String itf : classInfo.interfaces()) {
                if (!this.isAssignableFrom(type1, itf)) continue;
                return true;
            }
            type2 = classInfo.superClass();
        }
        return false;
    }

    default public IInheritanceChecker chain(IInheritanceChecker ... others) {
        return new ChainInheritanceChecker(Utils.prepend(this, others));
    }

    public record ClassInfo(@Nullable(value="null in the case of java.lang.Object") @Nullable(value="null in the case of java.lang.Object") String superClass, String[] interfaces, boolean isInterface) {
    }
}

