/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.api.classresolvers;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.impl.classresolvers.ClasspathClassResolver;
import daomephsta.unpick.impl.classresolvers.JarClassResolver;
import daomephsta.unpick.impl.classresolvers.PathClassResolver;
import java.nio.file.Path;
import java.util.zip.ZipFile;

public final class ClassResolvers {
    private ClassResolvers() {
    }

    public static IClassResolver classpath() {
        return ClassResolvers.classpath(Thread.currentThread().getContextClassLoader());
    }

    public static IClassResolver classpath(ClassLoader classLoader) {
        return new ClasspathClassResolver(classLoader);
    }

    public static IClassResolver fromDirectory(Path root) {
        return new PathClassResolver(root);
    }

    public static IClassResolver jar(ZipFile jarFile) {
        return new JarClassResolver(jarFile);
    }
}

