/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.api;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.classresolvers.IMemberChecker;
import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.ForwardingUnpickV3Visitor;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupScope;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetAnnotation;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetField;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import daomephsta.unpick.impl.DataTypeUtils;
import daomephsta.unpick.impl.constantmappers.datadriven.data.Data;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public abstract class ValidatingUnpickV3Visitor
extends ForwardingUnpickV3Visitor {
    private final IClassResolver classResolver;
    private final IMemberChecker memberChecker;
    private final Data data;
    private final Map<String, DataType> actualGroupTypes = new HashMap<String, DataType>();
    private final Map<String, Set<DataType>> expectedGroupTypes = new HashMap<String, Set<DataType>>();
    private final List<UnpickSyntaxException> errors = new ArrayList<UnpickSyntaxException>();

    public ValidatingUnpickV3Visitor(IClassResolver classResolver) {
        this(classResolver, null);
    }

    public ValidatingUnpickV3Visitor(IClassResolver classResolver, @Nullable UnpickV3Visitor downstream) {
        super(downstream);
        this.classResolver = classResolver;
        this.memberChecker = classResolver.asMemberChecker();
        this.data = new Data(null, false, classResolver.asConstantResolver(), classResolver.asInheritanceChecker());
    }

    public abstract boolean packageExists(String var1);

    @Override
    public void visitGroupDefinition(GroupDefinition groupDefinition) {
        try {
            if (groupDefinition.name() != null) {
                this.actualGroupTypes.put(groupDefinition.name(), groupDefinition.dataType());
            }
            block7: for (GroupScope scope : groupDefinition.scopes()) {
                GroupScope groupScope;
                Objects.requireNonNull(scope);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupScope.Package.class, GroupScope.Class.class, GroupScope.Method.class}, (Object)groupScope, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        GroupScope.Package packageScope = (GroupScope.Package)groupScope;
                        if (this.packageExists(packageScope.packageName())) continue block7;
                        throw new UnpickSyntaxException("Package " + packageScope.packageName() + " does not exist");
                    }
                    case 1: {
                        GroupScope.Class classScope = (GroupScope.Class)groupScope;
                        if (this.memberChecker.getFields(classScope.className().replace('.', '/')) != null) continue block7;
                        throw new UnpickSyntaxException("Class " + classScope.className() + " does not exist");
                    }
                    case 2: 
                }
                GroupScope.Method methodScope = (GroupScope.Method)groupScope;
                if (this.memberChecker.getMethod(methodScope.className().replace('.', '/'), methodScope.methodName(), methodScope.methodDesc()) != null) continue;
                throw new UnpickSyntaxException("Method " + methodScope.className() + "." + methodScope.methodName() + methodScope.methodDesc() + " does not exist");
            }
            this.data.visitGroupDefinition(groupDefinition);
        }
        catch (UnpickSyntaxException e) {
            this.errors.add(e);
        }
        super.visitGroupDefinition(groupDefinition);
    }

    @Override
    public void visitTargetField(TargetField targetField) {
        try {
            if (this.memberChecker.getField(targetField.className().replace('.', '/'), targetField.fieldName(), targetField.fieldDesc()) == null) {
                throw new UnpickSyntaxException("No such field: " + targetField.className() + "." + targetField.fieldName() + ":" + targetField.fieldDesc());
            }
            this.validateGroupType(targetField.groupName(), this.getDataTypeFromType(Type.getType(targetField.fieldDesc())));
            this.data.visitTargetField(targetField);
        }
        catch (UnpickSyntaxException e) {
            this.errors.add(e);
        }
        super.visitTargetField(targetField);
    }

    @Override
    public void visitTargetMethod(TargetMethod targetMethod) {
        try {
            if (this.memberChecker.getMethod(targetMethod.className().replace('.', '/'), targetMethod.methodName(), targetMethod.methodDesc()) == null) {
                throw new UnpickSyntaxException("No such method: " + targetMethod.className() + "." + targetMethod.methodName() + targetMethod.methodDesc());
            }
            if (targetMethod.returnGroup() != null) {
                this.validateGroupType(targetMethod.returnGroup(), this.getDataTypeFromType(Type.getReturnType(targetMethod.methodDesc())));
            }
            Type[] paramTypes = Type.getArgumentTypes(targetMethod.methodDesc());
            targetMethod.paramGroups().forEach((paramIndex, paramGroup) -> {
                if (paramIndex < 0 || paramIndex >= paramTypes.length) {
                    throw new UnpickSyntaxException("Parameter index out of bounds: " + paramIndex);
                }
                this.validateGroupType((String)paramGroup, this.getDataTypeFromType(paramTypes[paramIndex]));
            });
            this.data.visitTargetMethod(targetMethod);
        }
        catch (UnpickSyntaxException e) {
            this.errors.add(e);
        }
        super.visitTargetMethod(targetMethod);
    }

    @Override
    public void visitTargetAnnotation(TargetAnnotation targetAnnotation) {
        try {
            ClassNode node = this.classResolver.resolveClass(targetAnnotation.annotationName().replace('.', '/'));
            if (node == null) {
                throw new UnpickSyntaxException("No such annotation: " + targetAnnotation.annotationName());
            }
            if ((node.access & 0x2000) == 0) {
                throw new UnpickSyntaxException("Not an annotation: " + targetAnnotation.annotationName());
            }
            this.data.visitTargetAnnotation(targetAnnotation);
        }
        catch (UnpickSyntaxException e) {
            this.errors.add(e);
        }
        super.visitTargetAnnotation(targetAnnotation);
    }

    public List<UnpickSyntaxException> finishValidation() {
        this.expectedGroupTypes.forEach((groupName, expectedTypes) -> {
            DataType actualType = this.actualGroupTypes.get(groupName);
            if (actualType == null) {
                this.errors.add(new UnpickSyntaxException("Reference to undeclared group: " + groupName));
                return;
            }
            for (DataType expectedType : expectedTypes) {
                boolean compatible;
                if (expectedType == DataType.CHAR) {
                    compatible = actualType == DataType.INT || actualType == DataType.LONG;
                } else if (DataTypeUtils.isPrimitive(expectedType)) {
                    compatible = DataTypeUtils.isPrimitive(actualType);
                } else {
                    boolean bl = compatible = expectedType == actualType;
                }
                if (compatible) continue;
                this.errors.add(new UnpickSyntaxException("Target of type " + DataTypeUtils.getTypeName(expectedType) + " declares group " + groupName + " of incompatible type " + DataTypeUtils.getTypeName(actualType)));
            }
        });
        return this.errors;
    }

    private DataType getDataTypeFromType(Type type) {
        DataType result = DataTypeUtils.asmTypeToDataType(type);
        if (result == null) {
            throw new UnpickSyntaxException("Not an unpickable data type: " + type.getClassName());
        }
        return result;
    }

    private void validateGroupType(String groupName, DataType expectedType) {
        this.expectedGroupTypes.computeIfAbsent(groupName, k -> EnumSet.noneOf(DataType.class)).add(expectedType);
    }
}

