/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.mapping;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.mapping.MappingDataContainer;

public class ImmutableMappingDataContainer
implements MappingDataContainer {
    private final Set<MappingDataContainer.PackageData> packages;
    private final Map<String, MappingDataContainer.PackageData> packagesMap;
    private final Set<MappingDataContainer.ClassData> classes;
    private final Map<String, MappingDataContainer.ClassData> classesMap;

    public ImmutableMappingDataContainer(Collection<? extends MappingDataContainer.PackageData> packages, Collection<? extends MappingDataContainer.ClassData> classes) {
        this.packages = ImmutableSortedSet.copyOf(MappingDataContainer.PackageData.COMPARATOR, packages);
        this.classes = ImmutableSortedSet.copyOf(MappingDataContainer.ClassData.COMPARATOR, classes);
        this.packagesMap = Maps.uniqueIndex(this.packages, MappingDataContainer.PackageData::getName);
        this.classesMap = Maps.uniqueIndex(this.classes, MappingDataContainer.ClassData::getName);
    }

    @Override
    public Collection<? extends MappingDataContainer.PackageData> getPackages() {
        return this.packages;
    }

    @Override
    public @Nullable MappingDataContainer.PackageData getPackage(String packageName) {
        return this.packagesMap.get(packageName);
    }

    @Override
    public Collection<? extends MappingDataContainer.ClassData> getClasses() {
        return this.classes;
    }

    @Override
    public @Nullable MappingDataContainer.ClassData getClass(String className) {
        return this.classesMap.get(className);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MappingDataContainer)) {
            return false;
        }
        MappingDataContainer builder = (MappingDataContainer)o;
        return this.getPackages().equals(builder.getPackages()) && this.getClasses().equals(builder.getClasses());
    }

    public int hashCode() {
        return Objects.hash(this.getPackages(), this.getClasses());
    }

    public static class ImmutableParameterData
    implements MappingDataContainer.ParameterData {
        private final byte index;
        private final @Nullable String name;
        private final @Nullable String javadoc;

        public ImmutableParameterData(byte index, @Nullable String name, @Nullable String javadoc) {
            this.index = index;
            this.name = name;
            this.javadoc = javadoc;
        }

        @Override
        public byte getIndex() {
            return this.index;
        }

        @Override
        public @Nullable String getName() {
            return this.name;
        }

        @Override
        public @Nullable String getJavadoc() {
            return this.javadoc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.ParameterData)) {
                return false;
            }
            MappingDataContainer.ParameterData that = (MappingDataContainer.ParameterData)o;
            return this.getIndex() == that.getIndex() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getJavadoc(), that.getJavadoc());
        }

        public int hashCode() {
            return Objects.hash(this.getIndex(), this.getName(), this.getJavadoc());
        }
    }

    public static class ImmutableMethodData
    implements MappingDataContainer.MethodData {
        private final String name;
        private final String descriptor;
        private final List<String> javadoc;
        private final Set<MappingDataContainer.ParameterData> parameters;
        private final Map<Byte, MappingDataContainer.ParameterData> parametersMap;

        public ImmutableMethodData(String name, String descriptor, List<String> javadoc, Collection<? extends MappingDataContainer.ParameterData> parameters) {
            this.name = name;
            this.javadoc = ImmutableList.copyOf(javadoc);
            this.descriptor = descriptor;
            this.parameters = ImmutableSortedSet.copyOf(MappingDataContainer.ParameterData.COMPARATOR, parameters);
            this.parametersMap = Maps.uniqueIndex(this.parameters, MappingDataContainer.ParameterData::getIndex);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public List<String> getJavadoc() {
            return this.javadoc;
        }

        @Override
        public Collection<? extends MappingDataContainer.ParameterData> getParameters() {
            return this.parameters;
        }

        @Override
        public @Nullable MappingDataContainer.ParameterData getParameter(byte index) {
            return this.parametersMap.get(index);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.MethodData)) {
                return false;
            }
            MappingDataContainer.MethodData that = (MappingDataContainer.MethodData)o;
            return this.getName().equals(that.getName()) && this.getDescriptor().equals(that.getDescriptor()) && this.getJavadoc().equals(that.getJavadoc()) && this.getParameters().equals(that.getParameters());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getDescriptor(), this.getJavadoc(), this.getParameters());
        }
    }

    public static class ImmutableFieldData
    implements MappingDataContainer.FieldData {
        private final String name;
        private final String descriptor;
        private final List<String> javadoc;

        public ImmutableFieldData(String name, String descriptor, List<String> javadoc) {
            this.name = name;
            this.descriptor = descriptor;
            this.javadoc = ImmutableList.copyOf(javadoc);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public List<String> getJavadoc() {
            return this.javadoc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.FieldData)) {
                return false;
            }
            MappingDataContainer.FieldData that = (MappingDataContainer.FieldData)o;
            return this.getName().equals(that.getName()) && Objects.equals(this.getDescriptor(), that.getDescriptor()) && this.getJavadoc().equals(that.getJavadoc());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getDescriptor(), this.getJavadoc());
        }
    }

    public static class ImmutableClassData
    implements MappingDataContainer.ClassData {
        private final String name;
        private final List<String> javadoc;
        private final Set<MappingDataContainer.FieldData> fields;
        private final Map<String, MappingDataContainer.FieldData> fieldsMap;
        private final Set<MappingDataContainer.MethodData> methods;
        private final Map<String, MappingDataContainer.MethodData> methodsMap;

        public ImmutableClassData(String name, List<String> javadoc, Collection<? extends MappingDataContainer.FieldData> fields, Collection<? extends MappingDataContainer.MethodData> methods) {
            this.name = name;
            this.javadoc = ImmutableList.copyOf(javadoc);
            this.fields = ImmutableSortedSet.copyOf(MappingDataContainer.FieldData.COMPARATOR, fields);
            this.methods = ImmutableSortedSet.copyOf(MappingDataContainer.MethodData.COMPARATOR, methods);
            this.fieldsMap = Maps.uniqueIndex(this.fields, MappingDataContainer.FieldData::getName);
            this.methodsMap = Maps.uniqueIndex(this.methods, this::dataToKey);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getJavadoc() {
            return this.javadoc;
        }

        @Override
        public Collection<? extends MappingDataContainer.FieldData> getFields() {
            return this.fields;
        }

        @Override
        public @Nullable MappingDataContainer.FieldData getField(String fieldName) {
            return this.fieldsMap.get(fieldName);
        }

        @Override
        public Collection<? extends MappingDataContainer.MethodData> getMethods() {
            return this.methods;
        }

        @Override
        public @Nullable MappingDataContainer.MethodData getMethod(String methodName, String descriptor) {
            return this.methodsMap.get(this.key(methodName, descriptor));
        }

        private String key(String name, String descriptor) {
            return name + ":" + descriptor;
        }

        private String dataToKey(MappingDataContainer.MethodData method) {
            return this.key(method.getName(), method.getDescriptor());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.ClassData)) {
                return false;
            }
            MappingDataContainer.ClassData that = (MappingDataContainer.ClassData)o;
            return Objects.equals(this.getName(), that.getName()) && this.getJavadoc().equals(that.getJavadoc()) && this.getFields().equals(that.getFields()) && this.getMethods().equals(that.getMethods());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getJavadoc(), this.getFields(), this.getMethods());
        }
    }

    public static class ImmutablePackageData
    implements MappingDataContainer.PackageData {
        private final String name;
        private final List<String> javadoc;

        public ImmutablePackageData(String name, List<String> javadoc) {
            this.name = name;
            this.javadoc = ImmutableList.copyOf(javadoc);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getJavadoc() {
            return this.javadoc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MappingDataContainer.PackageData)) {
                return false;
            }
            MappingDataContainer.PackageData that = (MappingDataContainer.PackageData)o;
            return Objects.equals(this.getName(), that.getName()) && this.getJavadoc().equals(that.getJavadoc());
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getJavadoc());
        }
    }
}

