/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.report.type;

import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.hydrate.generic.LambdaClosure;
import dev.denwav.hypo.hydrate.generic.LocalClassClosure;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.ClassKind;
import dev.denwav.hypo.model.data.MethodData;
import io.papermc.codebook.report.type.Report;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntUnaryOperator;
import java.util.regex.Pattern;
import org.cadixdev.lorenz.model.Mapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MissingMethodParam
implements Report {
    private final Map<ClassData, List<String>> data = new ConcurrentHashMap<ClassData, List<String>>();
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile(".+\\$\\d+$");

    private void checkMappings(MethodData method, @Nullable MethodMapping methodMapping, int descriptorParamOffset, IntUnaryOperator descriptorToMappingOffset) {
        this.checkMappings(method, methodMapping, descriptorParamOffset, descriptorToMappingOffset, null);
    }

    private void checkMappings(MethodData method, @Nullable MethodMapping methodMapping, int descriptorParamOffset, IntUnaryOperator descriptorToMappingOffset, @Nullable LambdaClosure lambdaClosure) {
        if (method.params().size() == descriptorParamOffset) {
            return;
        }
        if (methodMapping == null || method.params().size() - descriptorParamOffset > methodMapping.getParameterMappings().size()) {
            this.reportMissingParam(method, methodMapping, descriptorParamOffset, descriptorToMappingOffset, lambdaClosure);
        }
    }

    private static boolean shouldSkipMapping(MethodData method, ClassData parentClass, @Nullable ClassData superClass, @Nullable List<LambdaClosure> lambdaCalls) {
        String name = method.name();
        if (name.startsWith("access$") && method.isSynthetic()) {
            return true;
        }
        if (name.startsWith("lambda$") && method.isSynthetic() && (lambdaCalls == null || lambdaCalls.isEmpty())) {
            return true;
        }
        String descriptorText = method.descriptorText();
        if (superClass != null && superClass.name().equals("java/lang/Enum") && name.equals("valueOf") && descriptorText.startsWith("(Ljava/lang/String;)")) {
            return true;
        }
        if (parentClass.is(ClassKind.RECORD) && name.equals("equals") && descriptorText.equals("(Ljava/lang/Object;)Z")) {
            return true;
        }
        return method.isSynthetic() && method.get(HypoHydration.SYNTHETIC_TARGET) != null;
    }

    private void handleConstructorMappings(MethodData method, ClassData parentClass, @Nullable MethodMapping methodMapping, @Nullable LocalClassClosure localClassClosure) throws IOException {
        if (parentClass.is(ClassKind.ENUM)) {
            this.checkMappings(method, methodMapping, 2, i -> i + 1);
        } else if (!ANONYMOUS_CLASS.matcher(parentClass.name()).matches()) {
            if (parentClass.outerClass() != null) {
                int descriptorParamOffset;
                int n = descriptorParamOffset = parentClass.isStaticInnerClass() ? 0 : 1;
                if (localClassClosure == null) {
                    this.checkMappings(method, methodMapping, descriptorParamOffset, i -> i + 1);
                } else {
                    this.checkMappings(method, methodMapping, descriptorParamOffset + localClassClosure.getParamLvtIndices().length, i -> i + 1);
                }
            } else {
                this.checkMappings(method, methodMapping, 0, i -> i + 1);
            }
        }
    }

    public void handleCheckingMappings(MethodData method, ClassData parentClass, @Nullable ClassData superClass, @Nullable List<LambdaClosure> lambdaCalls, @Nullable MethodMapping methodMapping, int @Nullable [] outerMethodParamLvtIndices, @Nullable LambdaClosure lambdaClosure, @Nullable LocalClassClosure localClassClosure) throws IOException {
        if (MissingMethodParam.shouldSkipMapping(method, parentClass, superClass, lambdaCalls)) {
            return;
        }
        if (method.isConstructor()) {
            this.handleConstructorMappings(method, parentClass, methodMapping, localClassClosure);
        } else if (outerMethodParamLvtIndices == null) {
            this.checkMappings(method, methodMapping, 0, i -> i + (method.isStatic() ? 0 : 1));
        } else {
            int descriptorOffset = !method.isStatic() && outerMethodParamLvtIndices.length > 0 && outerMethodParamLvtIndices[0] == 0 ? outerMethodParamLvtIndices.length - 1 : outerMethodParamLvtIndices.length;
            this.checkMappings(method, methodMapping, descriptorOffset, i -> i + (method.isStatic() ? 0 : 1), lambdaClosure);
        }
    }

    private void reportMissingParam(MethodData method, @Nullable MethodMapping methodMapping, int descriptorParamOffset, IntUnaryOperator descriptorToMappingOffset, @Nullable LambdaClosure lambdaClosure) {
        ClassData parentClass = method.parentClass();
        StringBuilder msg = new StringBuilder("\t#%s %s".formatted(method.name(), method.descriptorText()));
        if (lambdaClosure != null) {
            MethodData containingMethod = lambdaClosure.getContainingMethod();
            msg.append("%n\t\tLambda Source: %s#%s %s".formatted(containingMethod.parentClass().equals(parentClass) ? "" : containingMethod.parentClass().name(), containingMethod.name(), containingMethod.descriptorText()));
        }
        for (int i = descriptorParamOffset; i < method.params().size(); ++i) {
            int paramIdx = i;
            int lastIdxOfDot = method.param(i).toString().lastIndexOf(46);
            msg.append("%n\t\t%s\t%-50s\t%s".formatted(i, method.param(i).toString().substring(lastIdxOfDot + 1), Optional.ofNullable(methodMapping).flatMap(m4 -> m4.getParameterMapping(descriptorToMappingOffset.applyAsInt(paramIdx))).map(Mapping::getDeobfuscatedName).orElse("<<MISSING>>")));
        }
        this.data.computeIfAbsent(parentClass, ignored -> new ArrayList()).add(msg.toString());
    }

    @Override
    public String generate() {
        StringBuilder output = new StringBuilder();
        this.data.entrySet().stream().sorted(Comparator.comparing(entry -> ((ClassData)entry.getKey()).name())).forEach(entry -> {
            output.append("Missing param mappings in %s, Method Count: %s, Param Count: TODO\n".formatted(((ClassData)entry.getKey()).name(), ((List)entry.getValue()).size()));
            ((List)entry.getValue()).forEach(msg -> output.append((String)msg).append("\n"));
        });
        return output.toString();
    }
}

