/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.report.type;

import dev.denwav.hypo.model.data.MethodData;
import io.papermc.codebook.report.type.Report;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.tree.MethodInsnNode;

public class MissingMethodLvtSuggestion
implements Report {
    private static final Comparator<Map.Entry<String, AtomicInteger>> COMPARATOR = Comparator.comparing(e -> ((AtomicInteger)e.getValue()).get());
    private final Map<String, AtomicInteger> data = new ConcurrentHashMap<String, AtomicInteger>();

    public void reportMissingMethodLvtSuggestion(MethodData method, MethodInsnNode insn) {
        this.data.computeIfAbsent(method.name() + "," + insn.owner + "," + insn.desc, k -> new AtomicInteger(0)).incrementAndGet();
    }

    @Override
    public String generate() {
        StringBuilder output = new StringBuilder();
        this.data.entrySet().stream().sorted(COMPARATOR.reversed()).forEach(s2 -> output.append("missed: %s -- %s times%n".formatted(s2.getKey(), s2.getValue())));
        return output.toString();
    }
}

