/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import daomephsta.unpick.cli.Main;
import io.papermc.codebook.exceptions.UnexpectedException;
import io.papermc.codebook.pages.CodeBookPage;
import io.papermc.codebook.util.IOUtil;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UnpickPage
extends CodeBookPage {
    private final Path inputJar;
    private final List<Path> classpath;
    private final Path tempDir;
    private final @Nullable Path unpickDefinitions;
    private final @Nullable Path constantsJar;

    @Inject
    public UnpickPage(@CodeBookPage.InputJar Path inputJar, @CodeBookPage.ClasspathJars List<Path> classpath, @CodeBookPage.TempDir Path tempDir, @CodeBookPage.UnpickDefinitions @Nullable Path unpickDefinitions, @CodeBookPage.ConstantsJar @Nullable Path constantsJar) {
        this.inputJar = inputJar;
        this.classpath = classpath;
        this.tempDir = tempDir;
        this.unpickDefinitions = unpickDefinitions;
        this.constantsJar = constantsJar;
    }

    @Override
    public void exec() {
        if (this.unpickDefinitions == null || this.constantsJar == null) {
            return;
        }
        Path outputJar = this.tempDir.resolve("unpicked.jar");
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(List.of(IOUtil.absolutePathString(this.inputJar), IOUtil.absolutePathString(outputJar), IOUtil.absolutePathString(this.unpickDefinitions), IOUtil.absolutePathString(this.constantsJar)));
        args.addAll(this.classpath.stream().map(IOUtil::absolutePathString).toList());
        try {
            Main.main(args.toArray(new String[0]));
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to run unpick", e);
        }
        this.bind(CodeBookPage.InputJar.KEY).to(outputJar);
    }
}

