/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.denwav.hypo.asm.AsmClassDataProvider;
import dev.denwav.hypo.asm.hydrate.BridgeMethodHydrator;
import dev.denwav.hypo.asm.hydrate.LambdaCallHydrator;
import dev.denwav.hypo.asm.hydrate.LocalClassHydrator;
import dev.denwav.hypo.asm.hydrate.SuperConstructorHydrator;
import dev.denwav.hypo.core.HypoConfig;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.HydrationManager;
import dev.denwav.hypo.mappings.ChangeChain;
import dev.denwav.hypo.mappings.MappingsCompletionManager;
import dev.denwav.hypo.mappings.contributors.CopyLambdaParametersDown;
import dev.denwav.hypo.mappings.contributors.CopyMappingsDown;
import dev.denwav.hypo.mappings.contributors.CopyRecordParameters;
import dev.denwav.hypo.model.ClassProviderRoot;
import io.papermc.codebook.exceptions.UnexpectedException;
import io.papermc.codebook.pages.CodeBookPage;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.io.gson.MDCGsonAdapterFactory;
import org.parchmentmc.feather.io.gson.SimpleVersionAdapter;
import org.parchmentmc.feather.mapping.MappingDataContainer;
import org.parchmentmc.feather.mapping.VersionedMappingDataContainer;
import org.parchmentmc.feather.util.SimpleVersion;

public final class InspectJarPage
extends CodeBookPage {
    private final Path inputJar;
    private final List<Path> classpathJars;
    private final @Nullable Path paramMappings;
    private final HypoConfig config;

    @Inject
    public InspectJarPage(@CodeBookPage.InputJar Path inputJar, @CodeBookPage.ClasspathJars List<Path> classpathJars, @CodeBookPage.ParamMappings @Nullable Path paramMappings, @CodeBookPage.Hypo HypoConfig config) {
        this.inputJar = inputJar;
        this.classpathJars = classpathJars;
        this.paramMappings = paramMappings;
        this.config = config;
    }

    @Override
    public void exec() {
        HypoContext ctx;
        MappingSet lorenzMappings = this.loadMappings();
        try {
            ctx = HypoContext.builder().withProvider(AsmClassDataProvider.of(ClassProviderRoot.fromJar(this.inputJar))).withContextProvider(AsmClassDataProvider.of(ClassProviderRoot.fromJars(this.classpathJars.toArray(new Path[0])))).withContextProvider(AsmClassDataProvider.of(ClassProviderRoot.ofJdk())).withConfig(this.config).build();
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to open jar files", e);
        }
        this.bind(CodeBookPage.Hypo.KEY).to(ctx);
        try {
            HydrationManager.createDefault().register(BridgeMethodHydrator.create()).register(SuperConstructorHydrator.create()).register(LambdaCallHydrator.create()).register(LocalClassHydrator.create()).hydrate(ctx);
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to hydrate data model", e);
        }
        if (this.paramMappings != null) {
            MappingSet completedMappings = ChangeChain.create().addLink(CopyMappingsDown.createWithoutOverwrite(), CopyLambdaParametersDown.createWithoutOverwrite(), CopyRecordParameters.create()).applyChain(lorenzMappings, MappingsCompletionManager.create(ctx));
            this.bind(CodeBookPage.ParamMappings.KEY).to(completedMappings);
        } else {
            this.bind(CodeBookPage.ParamMappings.KEY).to(null);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private MappingSet loadMappings() {
        if (this.paramMappings == null) {
            return MappingSet.create();
        }
        Gson gson = new GsonBuilder().registerTypeAdapterFactory(new MDCGsonAdapterFactory()).registerTypeAdapter((Type)((Object)SimpleVersion.class), new SimpleVersionAdapter()).create();
        try (FileSystem fs = FileSystems.newFileSystem(this.paramMappings);){
            MappingSet mappingSet;
            block15: {
                Path jsonFile = fs.getPath("/parchment.json", new String[0]);
                BufferedReader reader = Files.newBufferedReader(jsonFile);
                try {
                    mappingSet = this.toLorenz(gson.fromJson((Reader)reader, VersionedMappingDataContainer.class));
                    if (reader == null) break block15;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return mappingSet;
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to read param mappings file", e);
        }
    }

    private MappingSet toLorenz(MappingDataContainer container) {
        MappingSet mappings = MappingSet.create();
        for (MappingDataContainer.ClassData classData : container.getClasses()) {
            ClassMapping<?, ?> classMapping = mappings.getOrCreateClassMapping(classData.getName());
            for (MappingDataContainer.MethodData methodData : classData.getMethods()) {
                MethodMapping methodMapping = classMapping.getOrCreateMethodMapping(methodData.getName(), methodData.getDescriptor());
                for (MappingDataContainer.ParameterData parameterData : methodData.getParameters()) {
                    methodMapping.getOrCreateParameterMapping(parameterData.getIndex()).setDeobfuscatedName(parameterData.getName());
                }
            }
            for (MappingDataContainer.FieldData fieldData : classData.getFields()) {
                classMapping.getOrCreateFieldMapping(FieldSignature.of(fieldData.getName(), fieldData.getDescriptor()));
            }
        }
        return mappings;
    }
}

