/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import com.google.common.collect.Iterables;
import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.asm.AsmFieldData;
import dev.denwav.hypo.asm.AsmMethodData;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.ClassKind;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.Visibility;
import io.papermc.codebook.exceptions.UnexpectedException;
import io.papermc.codebook.pages.CodeBookPage;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public final class FixJarPage
extends CodeBookPage {
    private final HypoContext context;

    @Inject
    public FixJarPage(@CodeBookPage.Hypo HypoContext context) {
        this.context = context;
    }

    @Override
    public void exec() {
        try {
            this.fixJar();
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to fix jar", e);
        }
    }

    private void fixJar() throws IOException {
        ArrayList tasks = new ArrayList();
        for (ClassData classData : this.context.getProvider().allClasses()) {
            Future<?> task = this.context.getExecutor().submit(() -> {
                try {
                    this.processClass((AsmClassData)classData);
                }
                catch (IOException e) {
                    throw HypoModelUtil.rethrow(e);
                }
            });
            tasks.add(task);
        }
        try {
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            throw new UnexpectedException("Failed to fix jar", e.getCause());
        }
        catch (InterruptedException e) {
            throw new UnexpectedException("Jar fixing interrupted", e);
        }
    }

    private void processClass(AsmClassData classData) throws IOException {
        OverrideAnnotationAdder.addAnnotations(classData);
        EmptyRecordFixer.fixClass(classData);
        RecordFieldAccessFixer.fixClass(classData);
        DeprecatedAnnotationAdder.addAnnotations(classData);
    }

    private static <T> List<T> appendToList(@Nullable List<T> list, T value) {
        if (list != null) {
            list.add(value);
            return list;
        }
        return new ArrayList<T>(List.of(value));
    }

    private static final class OverrideAnnotationAdder {
        private OverrideAnnotationAdder() {
        }

        private static void addAnnotations(AsmClassData classData) {
            for (MethodData method : classData.methods()) {
                MethodData baseMethod;
                block4: {
                    if (method.isStatic() || method.visibility() == Visibility.PRIVATE || OverrideAnnotationAdder.isInitializer(method)) continue;
                    @Nullable Set<MethodData> syntheticSources = method.get(HypoHydration.SYNTHETIC_SOURCES);
                    if (syntheticSources == null) {
                        baseMethod = method;
                    } else {
                        for (MethodData targetMethod : syntheticSources) {
                            if (!targetMethod.parentClass().equals(method.parentClass())) continue;
                            baseMethod = targetMethod;
                            break block4;
                        }
                        return;
                    }
                }
                if (baseMethod.superMethod() == null) continue;
                MethodNode node = ((AsmMethodData)method).getNode();
                String annoClass = "Ljava/lang/Override;";
                if (node.invisibleAnnotations != null && Iterables.any(node.invisibleAnnotations, a -> a.desc.equals("Ljava/lang/Override;"))) continue;
                node.invisibleAnnotations = FixJarPage.appendToList(node.invisibleAnnotations, new AnnotationNode("Ljava/lang/Override;"));
            }
        }

        private static boolean isInitializer(MethodData method) {
            return method.name().equals("<init>") || method.name().equals("<clinit>");
        }
    }

    private static final class EmptyRecordFixer {
        private EmptyRecordFixer() {
        }

        private static void fixClass(AsmClassData classData) throws IOException {
            if (classData.is(ClassKind.RECORD)) {
                return;
            }
            @Nullable ClassData superClass = classData.superClass();
            if (superClass == null) {
                return;
            }
            if (superClass.name().equals("java/lang/Record")) {
                classData.getNode().access |= 0x10000;
            }
        }
    }

    private static final class RecordFieldAccessFixer {
        private static final int RESET_ACCESS = -8;

        private RecordFieldAccessFixer() {
        }

        private static void fixClass(AsmClassData classData) {
            if (classData.isNot(ClassKind.RECORD)) {
                return;
            }
            for (FieldData field : classData.fields()) {
                if (field.isStatic() || field.visibility() == Visibility.PRIVATE || !field.isFinal()) continue;
                FieldNode node = ((AsmFieldData)field).getNode();
                node.access = node.access & 0xFFFFFFF8 | 2;
            }
        }
    }

    private static final class DeprecatedAnnotationAdder {
        private DeprecatedAnnotationAdder() {
        }

        private static void addAnnotations(AsmClassData classData) {
            for (MethodData method : classData.methods()) {
                MethodNode node = ((AsmMethodData)method).getNode();
                if ((node.access & 0x20000) == 0) continue;
                String annoClass = "Ljava/lang/Deprecated;";
                if (node.visibleAnnotations != null && Iterables.any(node.visibleAnnotations, a -> a.desc.equals("Ljava/lang/Deprecated;"))) continue;
                node.visibleAnnotations = FixJarPage.appendToList(node.visibleAnnotations, new AnnotationNode("Ljava/lang/Deprecated;"));
            }
        }
    }
}

