/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.util.Modules;
import com.google.inject.util.Providers;
import dev.denwav.hypo.core.HypoConfig;
import dev.denwav.hypo.core.HypoContext;
import io.papermc.codebook.config.CodeBookContext;
import io.papermc.codebook.report.Reports;
import jakarta.inject.Qualifier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.List;
import org.cadixdev.lorenz.MappingSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CodeBookPage {
    private final IdentityHashMap<Key<?>, @Nullable Object> injections = new IdentityHashMap();

    public abstract void exec();

    public Module exec(Module module) {
        this.injections.clear();
        this.exec();
        return Modules.override(module).with(this.nextModule());
    }

    public Module nextModule() {
        return new AbstractModule(){

            @Override
            protected void configure() {
                CodeBookPage.this.injections.forEach((k, v) -> {
                    LinkedBindingBuilder<Object> binding = this.bind(k);
                    if (v == null) {
                        binding.toProvider(Providers.of(null));
                    } else {
                        binding.toInstance(v);
                    }
                });
            }
        };
    }

    public <T> Binding<T> bind(Key<T> key) {
        return new Binding<T>(key);
    }

    public final class Binding<T> {
        private final Key<T> key;

        public Binding(Key<T> key) {
            this.key = key;
        }

        public void to(@Nullable T value) {
            CodeBookPage.this.injections.put(this.key, value);
        }
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Report {
        public static final Key<Reports> KEY = Key.get(Reports.class, Report.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Hypo {
        public static final Key<HypoContext> KEY = Key.get(HypoContext.class, Hypo.class);
        public static final Key<HypoConfig> CONFIG_KEY = Key.get(HypoConfig.class, Hypo.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TempDir {
        public static final Key<Path> KEY = Key.get(Path.class, TempDir.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConstantsJar {
        public static final Key<Path> KEY = Key.get(Path.class, ConstantsJar.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface UnpickDefinitions {
        public static final Key<Path> KEY = Key.get(Path.class, UnpickDefinitions.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ParamMappings {
        public static final Key<Path> PATH_KEY = Key.get(Path.class, ParamMappings.class);
        public static final Key<MappingSet> KEY = Key.get(MappingSet.class, ParamMappings.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MojangMappings {
        public static final Key<Path> PATH_KEY = Key.get(Path.class, MojangMappings.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ClasspathJars {
        public static final Key<List<Path>> KEY = Key.get(new TypeLiteral<List<Path>>(){}, ClasspathJars.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InputJar {
        public static final Key<Path> KEY = Key.get(Path.class, InputJar.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RemapperJar {
        public static final Key<List<Path>> KEY = Key.get(new TypeLiteral<List<Path>>(){}, RemapperJar.class);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Context {
        public static final Key<CodeBookContext> KEY = Key.get(CodeBookContext.class, Context.class);
    }
}

