/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion.numbers;

import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.types.JvmType;
import dev.denwav.hypo.model.data.types.PrimitiveType;
import io.papermc.codebook.lvt.LvtUtil;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

final class RandomUtil {
    private RandomUtil() {
    }

    static @Nullable String createNextRandomName(MethodData method) {
        @Nullable Predicate<String> expectedNextWord = RandomUtil.expectedNextWordForRandomGen(method);
        if (expectedNextWord == null) {
            return null;
        }
        String nextWord = LvtUtil.findNextWord("next".length(), method.name());
        if (expectedNextWord.test(nextWord)) {
            return "random" + nextWord;
        }
        return null;
    }

    static @Nullable Predicate<String> expectedNextWordForRandomGen(MethodData method) {
        JvmType jvmType = method.returnType();
        if (!(jvmType instanceof PrimitiveType)) {
            return null;
        }
        PrimitiveType primitiveType = (PrimitiveType)jvmType;
        return switch (primitiveType) {
            case PrimitiveType.CHAR -> LvtUtil.equalsAny("Char", "Character");
            case PrimitiveType.BYTE -> LvtUtil.equalsAny("Byte");
            case PrimitiveType.SHORT -> LvtUtil.equalsAny("Short");
            case PrimitiveType.INT -> LvtUtil.equalsAny("Int", "Integer");
            case PrimitiveType.LONG -> LvtUtil.equalsAny("Long");
            case PrimitiveType.FLOAT -> LvtUtil.equalsAny("Float");
            case PrimitiveType.DOUBLE -> LvtUtil.equalsAny("Double");
            case PrimitiveType.BOOLEAN -> LvtUtil.equalsAny("Bool", "Boolean");
            default -> null;
        };
    }
}

