/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion;

import dev.denwav.hypo.model.data.types.PrimitiveType;
import io.papermc.codebook.lvt.LvtUtil;
import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VerbPrefixBooleanSuggester
implements LvtSuggester {
    private static final List<String> BOOL_METHOD_PREFIXES = List.of("is", "has", "can", "should");

    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) {
        if (call.data().returnType() != PrimitiveType.BOOLEAN) {
            return null;
        }
        String methodName = call.data().name();
        @Nullable String prefix = LvtUtil.tryMatchPrefix(methodName, BOOL_METHOD_PREFIXES);
        if (prefix == null) {
            return null;
        }
        if (Character.isUpperCase(methodName.charAt(prefix.length()))) {
            return methodName;
        }
        return null;
    }
}

