/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion;

import io.papermc.codebook.lvt.LvtUtil;
import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class SingleVerbSuggester
implements LvtSuggester {
    private static final List<String> SINGLE_VERB_PREFIXES = List.of("getOrCreate", "get", "as", "read");

    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) {
        String methodName = call.data().name();
        @Nullable String prefix = LvtUtil.tryMatchPrefix(methodName, SINGLE_VERB_PREFIXES);
        if (prefix == null) {
            return null;
        }
        @Nullable String newName = SingleVerbSuggester.handleForLoop(methodName, insn, "getMin", "getMax");
        return newName != null ? newName : LvtUtil.parseSimpleTypeNameFromMethod(methodName, prefix.length());
    }

    public static @Nullable String handleForLoop(String methodName, MethodInsnContext insn, String minPrefix, String maxPrefix) {
        @Nullable String newName = SingleVerbSuggester.handleForLoopPrefix(methodName, insn.node(), minPrefix, maxPrefix);
        if (newName == null) {
            newName = SingleVerbSuggester.handleForLoopPrefix(methodName, insn.node(), maxPrefix, minPrefix);
        }
        return newName;
    }

    private static @Nullable String handleForLoopPrefix(String methodName, MethodInsnNode methodInsnNode, String first, String second) {
        if (methodName.startsWith(first)) {
            for (AbstractInsnNode nextInsn = methodInsnNode.getNext(); nextInsn != null && !(nextInsn instanceof LineNumberNode); nextInsn = nextInsn.getNext()) {
                if (!(nextInsn instanceof MethodInsnNode)) continue;
                MethodInsnNode afterMethodInvoke = (MethodInsnNode)nextInsn;
                if (!afterMethodInvoke.name.startsWith(second)) continue;
                return LvtUtil.parseSimpleTypeNameFromMethod(methodName, first.length());
            }
        }
        return null;
    }
}

