/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.model.data.MemberData;
import dev.denwav.hypo.model.data.types.JvmType;
import dev.denwav.hypo.model.data.types.PrimitiveType;
import io.papermc.codebook.lvt.LvtTypeSuggester;
import io.papermc.codebook.lvt.LvtUtil;
import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;

public class SingleVerbBooleanSuggester
implements LvtSuggester {
    private final HypoContext hypoContext;
    private final LvtTypeSuggester lvtTypeSuggester;

    @Inject
    SingleVerbBooleanSuggester(HypoContext hypoContext, LvtTypeSuggester lvtTypeSuggester) {
        this.hypoContext = hypoContext;
        this.lvtTypeSuggester = lvtTypeSuggester;
    }

    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) throws IOException {
        FieldInsnNode fieldInsnNode;
        String prefix;
        if (call.data().returnType() != PrimitiveType.BOOLEAN) {
            return null;
        }
        String methodName = call.data().name();
        if (methodName.equals("is")) {
            prefix = "is";
        } else if (methodName.equals("has")) {
            prefix = "has";
        } else {
            return null;
        }
        List<JvmType> paramTypes = call.data().params();
        if (paramTypes.size() != 1) {
            return null;
        }
        String paramTypeDesc = paramTypes.get(0).asInternalName();
        AbstractInsnNode prev = insn.node().getPrevious();
        if (prev instanceof FieldInsnNode && (fieldInsnNode = (FieldInsnNode)prev).getOpcode() == 178 && fieldInsnNode.name != null && LvtUtil.isStringAllUppercase(fieldInsnNode.name)) {
            boolean isFinal = Optional.ofNullable(this.hypoContext.getContextProvider().findClass(fieldInsnNode.owner)).map(fieldOwner -> fieldOwner.field(fieldInsnNode.name, LvtUtil.toJvmType(fieldInsnNode.desc))).map(MemberData::isFinal).orElse(false);
            if (!isFinal) {
                return null;
            }
            return prefix + SingleVerbBooleanSuggester.convertStaticFieldNameToLocalVarName(fieldInsnNode);
        }
        if ("Lnet/minecraft/tags/TagKey;".equals(paramTypeDesc)) {
            return "isTag";
        }
        String typeName = this.lvtTypeSuggester.suggestNameFromType(LvtUtil.toJvmType(paramTypeDesc));
        return prefix + LvtUtil.capitalize(typeName, 0);
    }

    private static String convertStaticFieldNameToLocalVarName(FieldInsnNode fieldInsnNode) {
        StringBuilder output = new StringBuilder();
        for (String s2 : fieldInsnNode.name.split("_")) {
            output.append(s2.charAt(0)).append(s2.substring(1).toLowerCase(Locale.ENGLISH));
        }
        return output.toString();
    }
}

