/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion;

import io.papermc.codebook.lvt.LvtUtil;
import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NewPrefixSuggester
implements LvtSuggester {
    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) throws IOException {
        String result;
        String methodName = call.data().name();
        if (!LvtUtil.hasPrefix(methodName, "new")) {
            return null;
        }
        switch (insn.owner().name()) {
            case "com/google/common/collect/Lists": {
                String string = "list";
                break;
            }
            case "com/google/common/collect/Maps": {
                String string = "map";
                break;
            }
            case "com/google/common/collect/Sets": {
                String string = "set";
                break;
            }
            default: {
                String string = result = null;
            }
        }
        if (result != null) {
            return result;
        }
        return LvtUtil.parseSimpleTypeNameFromMethod(methodName, 3);
    }
}

