/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion;

import dev.denwav.hypo.model.data.types.PrimitiveType;
import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.SingleVerbSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntPredicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;

public class FluentGetterSuggester
implements LvtSuggester {
    private static final Set<String> ignored = Set.of("byteValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue", "booleanValue", "charValue", "get");
    private static final IntPredicate[] OPCODES_IN_ORDER = new IntPredicate[]{i -> i == 25, i -> i == 180, i -> i >= 172 && i <= 177};

    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) throws IOException {
        if (!(call.data().returnType() instanceof PrimitiveType) || !call.data().params().isEmpty()) {
            return null;
        }
        int opcodeIndex = 0;
        InsnList instructions = call.node().instructions;
        if (instructions.size() == 0) {
            return null;
        }
        for (AbstractInsnNode methodInsn : instructions) {
            if (methodInsn.getOpcode() == -1) continue;
            if (opcodeIndex == OPCODES_IN_ORDER.length) break;
            if (OPCODES_IN_ORDER[opcodeIndex].test(methodInsn.getOpcode())) {
                ++opcodeIndex;
                continue;
            }
            return null;
        }
        if (call.data().isStatic()) {
            if ("java/lang/System".equals(insn.node().owner) && "currentTimeMillis".equals(insn.node().name)) {
                return "currentTimeMillis";
            }
        } else {
            String name = call.data().name();
            if (ignored.contains(name)) {
                return null;
            }
            @Nullable String forLoopAdjustedName = SingleVerbSuggester.handleForLoop(name, insn, "min", "max");
            return Objects.requireNonNullElse(forLoopAdjustedName, name);
        }
        return null;
    }
}

