/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.config;

import io.papermc.codebook.config.CodeBookClasspathResource;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CodeBookClasspathResourceBuilder {
    private List<Path> jars;

    private CodeBookClasspathResourceBuilder() {
    }

    private CodeBookClasspathResourceBuilder(List<Path> jars) {
        this.jars = jars;
    }

    public static CodeBookClasspathResource CodeBookClasspathResource(@NotNull List<Path> jars) {
        jars = CodeBookClasspathResourceBuilder.__list(jars);
        return new CodeBookClasspathResource(jars);
    }

    public static CodeBookClasspathResourceBuilder builder() {
        return new CodeBookClasspathResourceBuilder();
    }

    public static CodeBookClasspathResourceBuilder builder(CodeBookClasspathResource from) {
        return new CodeBookClasspathResourceBuilder(from.jars());
    }

    public static With from(CodeBookClasspathResource from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(CodeBookClasspathResource record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, List<Path>>("jars", record.jars()));
    }

    public CodeBookClasspathResource build() {
        this.jars = CodeBookClasspathResourceBuilder.__list(this.jars);
        return new CodeBookClasspathResource(this.jars);
    }

    public String toString() {
        return "CodeBookClasspathResourceBuilder[jars=" + String.valueOf(this.jars) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.jars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof CodeBookClasspathResourceBuilder)) return false;
        CodeBookClasspathResourceBuilder r = (CodeBookClasspathResourceBuilder)o;
        if (!Objects.equals(this.jars, r.jars)) return false;
        return true;
    }

    public CodeBookClasspathResourceBuilder jars(@NotNull Collection<? extends Path> jars) {
        this.jars = CodeBookClasspathResourceBuilder.__list(jars);
        return this;
    }

    @NotNull
    public List<Path> jars() {
        return CodeBookClasspathResourceBuilder.__list(this.jars);
    }

    public CodeBookClasspathResourceBuilder addJars(Path i) {
        this.jars = CodeBookClasspathResourceBuilder.__ensureListMutable(this.jars);
        this.jars.add(i);
        return this;
    }

    public CodeBookClasspathResourceBuilder addJars(Stream<? extends Path> i) {
        this.jars = CodeBookClasspathResourceBuilder.__ensureListMutable(this.jars);
        i.forEach(this.jars::add);
        return this;
    }

    public CodeBookClasspathResourceBuilder addJars(Iterable<? extends Path> i) {
        this.jars = CodeBookClasspathResourceBuilder.__ensureListMutable(this.jars);
        i.forEach(this.jars::add);
        return this;
    }

    private static <T> List<T> __list(Collection<? extends T> o) {
        return o != null ? List.copyOf(o) : List.of();
    }

    private static <T> List<T> __ensureListMutable(List<T> o) {
        if (o == null) {
            return new _MutableList();
        }
        if (o instanceof _MutableList) {
            return o;
        }
        return new _MutableList<T>(o);
    }

    private static final class _FromWith
    implements With {
        private final CodeBookClasspathResource from;

        private _FromWith(CodeBookClasspathResource from) {
            this.from = from;
        }

        @Override
        public List<Path> jars() {
            return this.from.jars();
        }
    }

    private static class _MutableList<T>
    extends ArrayList<T> {
        _MutableList() {
        }

        _MutableList(List<T> o) {
            super(o);
        }
    }

    public static interface With {
        @NotNull
        public List<Path> jars();

        default public CodeBookClasspathResourceBuilder with() {
            return new CodeBookClasspathResourceBuilder(this.jars());
        }

        default public CodeBookClasspathResource with(Consumer<CodeBookClasspathResourceBuilder> consumer) {
            CodeBookClasspathResourceBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public CodeBookClasspathResource withJars(@NotNull List<Path> jars) {
            return new CodeBookClasspathResource(CodeBookClasspathResourceBuilder.__list(jars));
        }
    }
}

