/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.contributors;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.mappings.ChangeRegistry;
import dev.denwav.hypo.mappings.LorenzUtil;
import dev.denwav.hypo.mappings.changes.MemberReference;
import dev.denwav.hypo.mappings.changes.RemoveClassMappingChange;
import dev.denwav.hypo.mappings.changes.RemoveMappingChange;
import dev.denwav.hypo.mappings.changes.RemoveParameterMappingChange;
import dev.denwav.hypo.mappings.contributors.ChangeContributor;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.MethodData;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedMappings
implements ChangeContributor {
    private RemoveUnusedMappings() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static RemoveUnusedMappings create() {
        return new RemoveUnusedMappings();
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
        if (classMapping == null) {
            return;
        }
        if (currentClass == null) {
            registry.submitChange(RemoveClassMappingChange.of(classMapping.getFullObfuscatedName()));
            return;
        }
        for (MethodMapping methodMapping : classMapping.getMethodMappings()) {
            MethodData method = LorenzUtil.findMethod(currentClass, methodMapping);
            if (method == null) {
                registry.submitChange(RemoveMappingChange.of(MemberReference.of(methodMapping)));
                continue;
            }
            if (method.isConstructor() && methodMapping.getParameterMappings().isEmpty()) {
                registry.submitChange(RemoveMappingChange.of(MemberReference.of(methodMapping)));
                continue;
            }
            MemberReference methodRef = null;
            for (MethodParameterMapping paramMapping : methodMapping.getParameterMappings()) {
                if (method.paramLvt(paramMapping.getIndex()) != null) continue;
                if (methodRef == null) {
                    methodRef = MemberReference.of(method);
                }
                registry.submitChange(RemoveParameterMappingChange.of(methodRef, paramMapping.getIndex()));
            }
        }
        for (FieldMapping fieldMapping : classMapping.getFieldMappings()) {
            if (!LorenzUtil.findField(currentClass, fieldMapping).isEmpty()) continue;
            registry.submitChange(RemoveMappingChange.of(MemberReference.of(fieldMapping)));
        }
    }

    @Override
    @NotNull
    public String name() {
        return "RemoveUnusedMappings";
    }
}

