/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.contributors;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.mappings.ChangeRegistry;
import dev.denwav.hypo.mappings.LorenzUtil;
import dev.denwav.hypo.mappings.changes.CopyMethodMappingChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import dev.denwav.hypo.mappings.changes.RemoveMappingChange;
import dev.denwav.hypo.mappings.contributors.ChangeContributor;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.MethodData;
import java.util.Set;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropagateMappingsUp
implements ChangeContributor {
    private PropagateMappingsUp() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static PropagateMappingsUp create() {
        return new PropagateMappingsUp();
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
        if (currentClass == null || classMapping == null) {
            return;
        }
        for (MethodMapping methodMapping : classMapping.getMethodMappings()) {
            MethodData method = LorenzUtil.findMethod(currentClass, methodMapping);
            if (method == null) continue;
            PropagateMappingsUp.walkUp(method, methodMapping, registry);
        }
    }

    private static void walkUp(@NotNull MethodData method, @NotNull MethodMapping baseMapping, @NotNull ChangeRegistry registry) {
        MethodMapping methodMapping;
        boolean walkSuper = true;
        ClassMapping<?, ?> classMapping = LorenzUtil.getClassMapping(baseMapping.getMappings(), method.parentClass().name());
        if (classMapping != null) {
            methodMapping = LorenzUtil.getMethodMapping(classMapping, method.name(), method.descriptorText());
            if (methodMapping != null && methodMapping != baseMapping) {
                PropagateMappingsUp.remove(registry, baseMapping);
                walkSuper = false;
            }
        } else {
            methodMapping = null;
        }
        MethodData superMethod = method.superMethod();
        Set<MethodData> syntheticSources = method.get(HypoHydration.SYNTHETIC_SOURCES);
        if (superMethod != null && !superMethod.parentClass().isContextClass() && walkSuper) {
            PropagateMappingsUp.walkUp(superMethod, baseMapping, registry);
        } else if (methodMapping == null && syntheticSources == null) {
            registry.submitChange(CopyMethodMappingChange.of(MemberReference.of(method), baseMapping));
            PropagateMappingsUp.remove(registry, baseMapping);
        } else if (superMethod != null && superMethod.parentClass().isContextClass() && syntheticSources == null) {
            PropagateMappingsUp.remove(registry, baseMapping);
        }
        if (syntheticSources != null) {
            for (MethodData source : syntheticSources) {
                PropagateMappingsUp.walkUp(source, baseMapping, registry);
            }
        }
    }

    private static void remove(@NotNull ChangeRegistry registry, @NotNull MethodMapping mapping) {
        registry.submitChange(RemoveMappingChange.of(MemberReference.of(mapping)));
    }

    @Override
    @NotNull
    public String name() {
        return "PropagateMappingsUp";
    }
}

