/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.contributors;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.mappings.ChangeRegistry;
import dev.denwav.hypo.mappings.LorenzUtil;
import dev.denwav.hypo.mappings.changes.AddNewParameterMappingsChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import dev.denwav.hypo.mappings.contributors.ChangeContributor;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.ClassKind;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.types.JvmType;
import dev.denwav.hypo.model.data.types.PrimitiveType;
import java.util.ArrayList;
import java.util.List;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyRecordParameters
implements ChangeContributor {
    private CopyRecordParameters() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static CopyRecordParameters create() {
        return new CopyRecordParameters();
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
        if (currentClass == null) {
            return;
        }
        if (currentClass.isNot(ClassKind.RECORD)) {
            return;
        }
        List<@NotNull FieldData> components = currentClass.recordComponents();
        if (components == null) {
            return;
        }
        ArrayList<@Nullable FieldMapping> componentMappings = new ArrayList<FieldMapping>();
        for (FieldData component : components) {
            FieldMapping fieldMapping = LorenzUtil.getFieldMapping(classMapping, component.name());
            componentMappings.add(fieldMapping);
        }
        block1: for (MethodData method : currentClass.methods()) {
            int len;
            if (!method.isConstructor() || (len = method.params().size()) != components.size()) continue;
            for (int i = 0; i < len; ++i) {
                if (!method.param(i).equals(components.get(i).fieldType())) continue block1;
            }
            int lvtIndex = 1;
            for (int i = 0; i < method.params().size(); ++i) {
                FieldMapping fieldMapping = (FieldMapping)componentMappings.get(i);
                String newName = fieldMapping != null ? fieldMapping.getDeobfuscatedName() : components.get(i).name();
                MemberReference ref = MemberReference.of(method, lvtIndex);
                registry.submitChange(AddNewParameterMappingsChange.of(ref, newName));
                ++lvtIndex;
                JvmType paramType = method.param(i);
                if (paramType != PrimitiveType.LONG && paramType != PrimitiveType.DOUBLE) continue;
                ++lvtIndex;
            }
        }
    }

    @Override
    @NotNull
    public String name() {
        return "CopyRecordParameters";
    }
}

