/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.changes;

import dev.denwav.hypo.mappings.MergeResult;
import dev.denwav.hypo.mappings.MergeableMappingsChange;
import dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import java.util.Collection;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CopyMethodMappingChange
extends AbstractMappingsChange
implements MergeableMappingsChange<CopyMethodMappingChange> {
    @NotNull
    private final MethodMapping mapping;

    private CopyMethodMappingChange(@NotNull MemberReference target, @NotNull MethodMapping mapping) {
        super(target);
        this.mapping = mapping;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static CopyMethodMappingChange of(@NotNull MemberReference target, @NotNull MethodMapping mapping) {
        return new CopyMethodMappingChange(target, mapping);
    }

    @NotNull
    public MethodMapping methodMapping() {
        return this.mapping;
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        ClassMapping<?, ?> map = input.getOrCreateClassMapping(target.className());
        MethodMapping newMapping = map.getOrCreateMethodMapping(target.name(), target.desc());
        newMapping.setDeobfuscatedName(this.mapping.getDeobfuscatedName());
        for (MethodParameterMapping paramMapping : this.mapping.getParameterMappings()) {
            newMapping.getOrCreateParameterMapping(paramMapping.getIndex()).setDeobfuscatedName(paramMapping.getDeobfuscatedName());
        }
    }

    @Override
    @NotNull
    public MergeResult<CopyMethodMappingChange> mergeWith(@NotNull CopyMethodMappingChange that) {
        if (!this.mapping.getDeobfuscatedName().equals(that.mapping.getDeobfuscatedName())) {
            return MergeResult.failure("Cannot merge copies with different target mappings");
        }
        Collection<MethodParameterMapping> thisParams = this.mapping.getParameterMappings();
        Collection<MethodParameterMapping> thatParams = that.mapping.getParameterMappings();
        if (thisParams.size() > thatParams.size()) {
            return MergeResult.success(this);
        }
        return MergeResult.success(that);
    }

    public String toString() {
        return "Copy mapping '" + this.mapping.getFullDeobfuscatedName() + "' to " + this.target();
    }
}

