/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.core;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.denwav.hypo.core.DefaultClassDataDecorator;
import dev.denwav.hypo.model.ClassDataDecorator;
import dev.denwav.hypo.model.ClassDataProvider;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class HypoConfig {
    private final int parallelism;
    @NotNull
    private final Function<ClassDataProvider, ClassDataDecorator> decorator;
    private final boolean requireFullClasspath;

    HypoConfig(int parallelism, @NotNull Function<ClassDataProvider, ClassDataDecorator> decorator, boolean requireFullClasspath) {
        this.parallelism = parallelism;
        this.decorator = decorator;
        this.requireFullClasspath = requireFullClasspath;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    @NotNull
    public Function<ClassDataProvider, ClassDataDecorator> getDecorator() {
        return this.decorator;
    }

    public boolean isRequireFullClasspath() {
        return this.requireFullClasspath;
    }

    @Contract(value="-> new ", pure=true)
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int parallelism = -1;
        @NotNull
        private Function<ClassDataProvider, ClassDataDecorator> decorator = DefaultClassDataDecorator::new;
        private boolean requireFullClasspath = true;

        Builder() {
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withDecorator(@NotNull Function<ClassDataProvider, ClassDataDecorator> decorator) {
            this.decorator = decorator;
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder setRequireFullClasspath(boolean requireFullClasspath) {
            this.requireFullClasspath = requireFullClasspath;
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="-> new", pure=true)
        @NotNull
        public HypoConfig build() {
            return new HypoConfig(this.parallelism, this.decorator, this.requireFullClasspath);
        }
    }
}

