/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.asm;

import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.core.HypoOutputWriter;
import dev.denwav.hypo.model.ClassProviderRoot;
import dev.denwav.hypo.model.JarClassProviderRoot;
import dev.denwav.hypo.model.data.ClassData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public final class AsmOutputWriter
implements HypoOutputWriter {
    @NotNull
    private final Path outputFile;

    private AsmOutputWriter(@NotNull Path outputFile) {
        this.outputFile = outputFile;
    }

    @NotNull
    public static AsmOutputWriter to(@NotNull Path output) {
        if (Files.exists(output, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot write to jar file, as it already exists: " + output);
        }
        return new AsmOutputWriter(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull HypoContext context) throws IOException {
        AsmOutputWriter.createParentDirectories(this.outputFile);
        try (OutputStream out = Files.newOutputStream(this.outputFile, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(out);
             ZipOutputStream zos = new ZipOutputStream(bos);){
            for (ClassProviderRoot root : context.getProvider().roots()) {
                if (!(root instanceof JarClassProviderRoot)) continue;
                JarClassProviderRoot jarRoot = (JarClassProviderRoot)root;
                Path jarFile = jarRoot.getJarFile();
                InputStream in = Files.newInputStream(jarFile, new OpenOption[0]);
                try (BufferedInputStream bis = new BufferedInputStream(in);
                     ZipInputStream zis = new ZipInputStream(bis);){
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        ZipEntry outEntry = new ZipEntry(entry);
                        zos.putNextEntry(outEntry);
                        try {
                            this.writeFile(context, outEntry, zis, zos);
                        }
                        finally {
                            zos.closeEntry();
                        }
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    private void writeFile(@NotNull HypoContext context, @NotNull ZipEntry entry, @NotNull ZipInputStream in, @NotNull ZipOutputStream out) throws IOException {
        if (entry.isDirectory()) {
            return;
        }
        if (!entry.getName().endsWith(".class")) {
            AsmOutputWriter.copy(in, out);
            return;
        }
        ClassData data = context.getProvider().findClass(AsmOutputWriter.removeClassSuffix(entry.getName()));
        if (data == null) {
            throw new IllegalStateException("Can no longer find " + entry.getName());
        }
        if (!(data instanceof AsmClassData)) {
            throw new IllegalStateException("Cannot handle ClassData objects which are not " + AsmClassData.class.getName() + " - found: " + data.getClass().getName());
        }
        ClassNode node = ((AsmClassData)data).getNode();
        ClassWriter writer = new ClassWriter(0);
        node.accept(writer);
        byte[] classBytes = writer.toByteArray();
        out.write(classBytes);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] data = new byte[8096];
        while ((read = in.read(data)) > 0) {
            out.write(data, 0, read);
        }
    }

    @NotNull
    private static String removeClassSuffix(@NotNull String text) {
        return text.substring(0, text.length() - 6);
    }

    private static void createParentDirectories(@NotNull Path path) throws IOException {
        Path parent = path.getParent();
        if (parent == null) {
            return;
        }
        Files.createDirectories(parent, new FileAttribute[0]);
    }
}

