/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.api.IClassResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class TargetImplementations {
    private final Map<String, TargetInvocation> methods;
    private final IClassResolver classResolver;

    private TargetImplementations(IClassResolver classResolver, Map<String, TargetInvocation> methods) {
        this.classResolver = classResolver;
        this.methods = methods;
    }

    public boolean targets(String methodOwner, String methodName, String methodDescriptor) {
        TargetInvocation targetMethod = this.methods.get(methodName + methodDescriptor);
        if (targetMethod == null) {
            return false;
        }
        return targetMethod.implementedBy(this.classResolver, methodOwner);
    }

    public boolean targets(String methodOwner, String methodName, String methodDescriptor, int parameterIndex) {
        TargetInvocation targetMethod = this.methods.get(methodName + methodDescriptor);
        return targetMethod.hasParameterConstantGroup(parameterIndex);
    }

    public String getParameterConstantGroup(String methodOwner, String methodName, String methodDescriptor, int parameterIndex) {
        TargetInvocation targetMethod = this.methods.get(methodName + methodDescriptor);
        return targetMethod.getParameterConstantGroup(parameterIndex);
    }

    public static class TargetInvocation {
        private final String declarator;
        private final String name;
        private final Set<String> implementors = new HashSet<String>();
        private final Set<String> nonimplementors = new HashSet<String>();
        private final Type descriptor;
        private final Map<Integer, String> parameterConstantGroups;

        public TargetInvocation(String owner, String name, Type descriptor, Map<Integer, String> parameterConstantGroups) {
            this.declarator = owner;
            this.name = name;
            this.descriptor = descriptor;
            this.parameterConstantGroups = parameterConstantGroups;
        }

        public String getParameterConstantGroup(int parameterIndex) {
            return this.parameterConstantGroups.get(parameterIndex);
        }

        public boolean hasParameterConstantGroup(int parameterIndex) {
            return this.parameterConstantGroups.containsKey(parameterIndex);
        }

        public boolean implementedBy(IClassResolver classResolver, String classInternalName) {
            if (this.declarator.equals(classInternalName) || this.implementors.contains(classInternalName)) {
                return true;
            }
            if (this.nonimplementors.contains(classInternalName)) {
                return false;
            }
            if (InheritanceChecker.inheritsFrom(589824, classResolver, classInternalName, this.declarator)) {
                this.implementors.add(classInternalName);
                return true;
            }
            this.nonimplementors.add(classInternalName);
            return false;
        }

        public String toString() {
            return String.format("TargetMethod {Qualified Name: %s.%s, Descriptor: %s, Parameter Constant Groups: %s}", this.declarator, this.name, this.descriptor, this.parameterConstantGroups);
        }
    }

    private static class InheritanceChecker
    extends ClassVisitor {
        private final IClassResolver classResolver;
        private final String targetOwner;
        private boolean result = false;

        public static boolean inheritsFrom(int api, IClassResolver classResolver, String clazz, String targetOwner) {
            try {
                ClassReader classReader = classResolver.resolveClass(clazz);
                InheritanceChecker inheritanceChecker = new InheritanceChecker(api, classResolver, targetOwner);
                classReader.accept(inheritanceChecker, 0);
                return inheritanceChecker.result;
            }
            catch (IClassResolver.ClassResolutionException e) {
                e.printStackTrace();
                return false;
            }
        }

        public InheritanceChecker(int api, IClassResolver classResolver, String targetOwner) {
            super(api);
            this.classResolver = classResolver;
            this.targetOwner = targetOwner;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (this.targetOwner.equals(name)) {
                this.result = true;
                return;
            }
            try {
                if (superName != null && !superName.equals("java/lang/Object")) {
                    ClassReader classReader = this.classResolver.resolveClass(superName);
                    classReader.accept(this, 0);
                    if (this.result) {
                        return;
                    }
                }
                if (interfaces != null) {
                    for (String iface : interfaces) {
                        ClassReader classReader = this.classResolver.resolveClass(iface);
                        classReader.accept(this, 0);
                        if (!this.result) continue;
                        return;
                    }
                }
            }
            catch (IClassResolver.ClassResolutionException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Builder {
        private final IClassResolver classResolver;
        private final Map<String, TargetInvocation> targetMethods = new HashMap<String, TargetInvocation>();

        public Builder(IClassResolver classResolver) {
            this.classResolver = classResolver;
        }

        public void putInvocation(String owner, String name, Type descriptor, Map<Integer, String> parameterConstantGroups) {
            this.targetMethods.put(name + descriptor, new TargetInvocation(owner, name, descriptor, parameterConstantGroups));
        }

        public TargetImplementations build() {
            return new TargetImplementations(this.classResolver, this.targetMethods);
        }
    }
}

