/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.api.constantresolvers.IConstantResolver;
import daomephsta.unpick.impl.UnpickValue;
import daomephsta.unpick.impl.representations.ReplacementSet;
import java.util.logging.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.analysis.Frame;

public interface ReplacementInstructionGenerator {
    public boolean canReplace(Context var1);

    public void generateReplacements(Context var1);

    public static class Context {
        private final IConstantResolver constantResolver;
        private final ReplacementSet replacementSet;
        private final AbstractInsnNode argSeed;
        private final InsnList instructions;
        private final Frame<UnpickValue>[] frames;
        private final Logger logger;

        public Context(IConstantResolver constantResolver, ReplacementSet replacementSet, AbstractInsnNode argSeed, InsnList instructions, Frame<UnpickValue>[] frames, Logger logger) {
            this.constantResolver = constantResolver;
            this.replacementSet = replacementSet;
            this.argSeed = argSeed;
            this.instructions = instructions;
            this.frames = frames;
            this.logger = logger;
        }

        public IConstantResolver getConstantResolver() {
            return this.constantResolver;
        }

        public ReplacementSet getReplacementSet() {
            return this.replacementSet;
        }

        public AbstractInsnNode getArgSeed() {
            return this.argSeed;
        }

        public Frame<UnpickValue> getFrameForInstruction(AbstractInsnNode insn) {
            return this.frames[this.instructions.indexOf(insn)];
        }

        public Logger getLogger() {
            return this.logger;
        }
    }
}

