/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.impl.IntegerType;
import daomephsta.unpick.impl.representations.AbstractConstantDefinition;
import org.objectweb.asm.Type;

public class FlagDefinition
extends AbstractConstantDefinition<FlagDefinition> {
    public FlagDefinition(String owner, String name) {
        super(owner, name);
    }

    public FlagDefinition(String owner, String name, Type descriptor, String valueString) {
        super(owner, name, descriptor, valueString);
    }

    @Override
    protected Number parseValue(String valueString) {
        try {
            return IntegerType.from(this.descriptor).parse(valueString);
        }
        catch (IllegalArgumentException e) {
            throw new UnpickSyntaxException("Cannot parse value " + valueString + " with descriptor " + this.descriptor, e);
        }
    }

    @Override
    protected void setValue(Object value) throws AbstractConstantDefinition.ResolutionException {
        try {
            IntegerType.from(value);
            this.value = value;
        }
        catch (IllegalArgumentException e) {
            throw new AbstractConstantDefinition.ResolutionException(value + " is not of a valid flag type", e);
        }
    }

    @Override
    public Number getValue() {
        return (Number)super.getValue();
    }

    public String toString() {
        if (this.isResolved()) {
            return String.format("FlagDefinition {Qualified Name: %s.%s, Descriptor: %s, Bits: %s}", this.owner, this.name, this.descriptor, Long.toBinaryString(this.getValue().longValue()));
        }
        return String.format("FlagDefinition {Qualified Name: %s.%s}", this.owner, this.name);
    }
}

