/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import daomephsta.unpick.impl.UnpickValue;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;
import org.objectweb.asm.tree.analysis.Value;

public class UnpickInterpreter
extends Interpreter<UnpickValue>
implements Opcodes {
    private final MethodNode method;
    private final SourceInterpreter delegate = new SourceInterpreter();

    public UnpickInterpreter(MethodNode method) {
        super(589824);
        this.method = method;
    }

    @Override
    public UnpickValue newParameterValue(boolean isInstanceMethod, int local, Type type) {
        UnpickValue value = this.newValue(type);
        int localIndex = isInstanceMethod ? 1 : 0;
        int paramIndex = 0;
        for (Type argument : Type.getArgumentTypes(this.method.desc)) {
            if (localIndex == local) break;
            localIndex += argument.getSize();
            ++paramIndex;
        }
        value.getParameterSources().add(paramIndex);
        return value;
    }

    @Override
    public UnpickValue newValue(Type type) {
        if (type == Type.VOID_TYPE) {
            return null;
        }
        return new UnpickValue(this.delegate.newValue(type));
    }

    @Override
    public UnpickValue newOperation(AbstractInsnNode insn) {
        UnpickValue value = new UnpickValue(this.delegate.newOperation(insn));
        value.getUsages().add(insn);
        return value;
    }

    @Override
    public UnpickValue copyOperation(AbstractInsnNode insn, UnpickValue value) {
        return new UnpickValue(this.delegate.copyOperation(insn, value.getSourceValue()), value);
    }

    @Override
    public UnpickValue unaryOperation(AbstractInsnNode insn, UnpickValue value) {
        UnpickValue newValue = new UnpickValue(this.delegate.unaryOperation(insn, value.getSourceValue()), value);
        if (insn.getType() == 4 || insn.getType() == 7 || insn.getOpcode() >= 172 && insn.getOpcode() <= 177) {
            newValue.getUsages().add(insn);
        }
        return newValue;
    }

    @Override
    public UnpickValue binaryOperation(AbstractInsnNode insn, UnpickValue value1, UnpickValue value2) {
        SourceValue sourceValue = this.delegate.binaryOperation(insn, value1.getSourceValue(), value2.getSourceValue());
        switch (insn.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new UnpickValue(sourceValue);
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                return new UnpickValue(sourceValue, this.merge(value1, value2));
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                return new UnpickValue(sourceValue, value1);
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.merge(value1, value2);
                return new UnpickValue(sourceValue);
            }
            case 181: {
                value2.getUsages().add(insn);
                return new UnpickValue(sourceValue);
            }
        }
        throw new IllegalArgumentException("Unrecognized insn: " + insn.getOpcode());
    }

    @Override
    public UnpickValue ternaryOperation(AbstractInsnNode insn, UnpickValue value1, UnpickValue value2, UnpickValue value3) {
        return new UnpickValue(this.delegate.ternaryOperation(insn, value1.getSourceValue(), value2.getSourceValue(), value3.getSourceValue()));
    }

    @Override
    public UnpickValue naryOperation(AbstractInsnNode insn, List<? extends UnpickValue> values) {
        int i;
        Value sourceValue = this.delegate.naryOperation(insn, values.stream().map(UnpickValue::getSourceValue).collect(Collectors.toList()));
        if (insn.getOpcode() == 197) {
            return new UnpickValue((SourceValue)sourceValue);
        }
        boolean hasThis = insn.getOpcode() != 184 && insn.getOpcode() != 186;
        int n = i = hasThis ? 1 : 0;
        while (i < values.size()) {
            values.get(i).getMethodUsages().add(new UnpickValue.MethodUsage(insn, hasThis ? i - 1 : i));
            ++i;
        }
        UnpickValue value = new UnpickValue((SourceValue)sourceValue);
        value.getUsages().add(insn);
        return value;
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, UnpickValue value, UnpickValue expected) {
    }

    @Override
    public UnpickValue merge(UnpickValue value1, UnpickValue value2) {
        value1.getParameterSources().addAll(value2.getParameterSources());
        value1.getMethodUsages().addAll(value2.getMethodUsages());
        value1.getUsages().addAll(value2.getUsages());
        value2.setParameterSources(value1.getParameterSources());
        value2.setMethodUsages(value1.getMethodUsages());
        value2.setUsages(value1.getUsages());
        return new UnpickValue(this.delegate.merge(value1.getSourceValue(), value2.getSourceValue()), value1);
    }
}

