/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import daomephsta.unpick.impl.InstructionFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;

public enum LiteralType {
    BYTE((Class)Byte.class, (Class)Byte.TYPE, Type.BYTE_TYPE, 172){

        @Override
        public AbstractInsnNode createLiteralPushInsn(Object literal) {
            return InstructionFactory.pushesInt(((Number)literal).byteValue());
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, Object literal) {
            InstructionFactory.pushesInt(mv, ((Number)literal).byteValue());
        }

        @Override
        public Object parse(String valueString) {
            return Byte.parseByte(valueString);
        }
    }
    ,
    SHORT((Class)Short.class, (Class)Short.TYPE, Type.SHORT_TYPE, 172){

        @Override
        public AbstractInsnNode createLiteralPushInsn(Object literal) {
            return InstructionFactory.pushesInt(((Number)literal).shortValue());
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, Object literal) {
            InstructionFactory.pushesInt(mv, ((Number)literal).shortValue());
        }

        @Override
        public Object parse(String valueString) {
            return Short.parseShort(valueString);
        }
    }
    ,
    CHAR((Class)Character.class, (Class)Character.TYPE, Type.CHAR_TYPE, 172){

        @Override
        public AbstractInsnNode createLiteralPushInsn(Object literal) {
            return InstructionFactory.pushesChar(((Character)literal).charValue());
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, Object literal) {
            InstructionFactory.pushesChar(mv, ((Character)literal).charValue());
        }

        @Override
        public Object parse(String valueString) {
            Matcher m4 = UNICODE_ESCAPE.matcher(valueString);
            if (m4.matches()) {
                return Character.valueOf((char)Integer.parseInt(m4.group(1), 16));
            }
            if (valueString.length() != 1) {
                throw new IllegalArgumentException(valueString + " is not a single character or valid unicode escape");
            }
            return Character.valueOf(valueString.charAt(0));
        }
    }
    ,
    INT((Class)Integer.class, (Class)Integer.TYPE, Type.INT_TYPE, 172){

        @Override
        public AbstractInsnNode createLiteralPushInsn(Object literal) {
            return InstructionFactory.pushesInt(((Number)literal).intValue());
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, Object literal) {
            InstructionFactory.pushesInt(mv, ((Number)literal).intValue());
        }

        @Override
        public Object parse(String valueString) {
            return Integer.parseInt(valueString);
        }
    }
    ,
    LONG((Class)Long.class, (Class)Long.TYPE, Type.LONG_TYPE, 173){

        @Override
        public AbstractInsnNode createLiteralPushInsn(Object literal) {
            return InstructionFactory.pushesLong(((Number)literal).longValue());
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, Object literal) {
            InstructionFactory.pushesLong(mv, ((Number)literal).longValue());
        }

        @Override
        public Object parse(String valueString) {
            return Long.parseLong(valueString);
        }
    }
    ,
    FLOAT((Class)Float.class, (Class)Float.TYPE, Type.FLOAT_TYPE, 174){

        @Override
        public AbstractInsnNode createLiteralPushInsn(Object literal) {
            return InstructionFactory.pushesFloat(((Number)literal).floatValue());
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, Object literal) {
            InstructionFactory.pushesFloat(mv, ((Number)literal).floatValue());
        }

        @Override
        public Object parse(String valueString) {
            return Float.valueOf(Float.parseFloat(valueString));
        }
    }
    ,
    DOUBLE((Class)Double.class, (Class)Double.TYPE, Type.DOUBLE_TYPE, 175){

        @Override
        public AbstractInsnNode createLiteralPushInsn(Object literal) {
            return InstructionFactory.pushesDouble(((Number)literal).doubleValue());
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, Object literal) {
            InstructionFactory.pushesDouble(mv, ((Number)literal).doubleValue());
        }

        @Override
        public Object parse(String valueString) {
            return Double.parseDouble(valueString);
        }
    }
    ,
    STRING((Class)String.class, (Class)String.class, Type.getType(String.class), 176){

        @Override
        public AbstractInsnNode createLiteralPushInsn(Object literal) {
            return InstructionFactory.pushesString((String)literal);
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, Object literal) {
            InstructionFactory.pushesString(mv, (String)literal);
        }

        @Override
        public Object parse(String valueString) {
            return valueString;
        }
    }
    ,
    TYPE_REFERENCE((Class)Type.class, (Class)Type.class, Type.getType(Type.class), 176){

        @Override
        public AbstractInsnNode createLiteralPushInsn(Object literal) {
            return InstructionFactory.pushesTypeReference((Type)literal);
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, Object literal) {
            InstructionFactory.pushesTypeReference(mv, (Type)literal);
        }

        @Override
        public Object parse(String valueString) {
            return Type.getType(valueString);
        }
    };

    private static final Pattern UNICODE_ESCAPE;
    private static final Map<Class<?>, LiteralType> valuesByClass;
    private static final Map<Type, LiteralType> valuesByType;
    private final Class<?> boxed;
    private final Class<?> primitive;
    private final Type type;
    private final int returnOpcode;

    private LiteralType(Class<?> boxed, Class<?> primitive, Type type, int returnOpcode) {
        this.boxed = boxed;
        this.primitive = primitive;
        this.type = type;
        this.returnOpcode = returnOpcode;
    }

    public static LiteralType from(Class<?> clazz) {
        if (valuesByClass.containsKey(clazz)) {
            return valuesByClass.get(clazz);
        }
        throw new IllegalArgumentException(clazz + " is not one of: " + LiteralType.describeValidTypes());
    }

    public static LiteralType from(Type type) {
        if (valuesByType.containsKey(type)) {
            return valuesByType.get(type);
        }
        throw new IllegalArgumentException(type + " is not one of: " + LiteralType.describeValidTypes());
    }

    private static String describeValidTypes() {
        return Arrays.stream(LiteralType.values()).map(t2 -> t2.name().toLowerCase(Locale.ROOT).replace('_', ' ')).collect(Collectors.joining(", "));
    }

    public AbstractInsnNode createReturnInsn() {
        return new InsnNode(this.getReturnOpcode());
    }

    public void appendReturnInsn(MethodVisitor mv) {
        mv.visitInsn(this.getReturnOpcode());
    }

    public int getReturnOpcode() {
        return this.returnOpcode;
    }

    public abstract AbstractInsnNode createLiteralPushInsn(Object var1);

    public abstract void appendLiteralPushInsn(MethodVisitor var1, Object var2);

    public abstract Object parse(String var1);

    public Type getType() {
        return this.type;
    }

    public String getTypeDescriptor() {
        return this.type.getDescriptor();
    }

    public Class<?> getBoxClass() {
        return this.boxed;
    }

    public Class<?> getPrimitiveClass() {
        return this.primitive;
    }

    static {
        UNICODE_ESCAPE = Pattern.compile("\\\\u+([0-9a-fA-F]{1,4})");
        valuesByClass = new HashMap();
        valuesByType = new HashMap<Type, LiteralType>();
        for (LiteralType literalType : LiteralType.values()) {
            valuesByClass.put(literalType.getPrimitiveClass(), literalType);
            valuesByClass.put(literalType.getBoxClass(), literalType);
            valuesByType.put(literalType.getType(), literalType);
        }
    }
}

