/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import daomephsta.unpick.impl.Utils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

public class AbstractInsnNodes {
    public static boolean hasLiteralValue(AbstractInsnNode insn) {
        return insn.getOpcode() >= 2 && insn.getOpcode() <= 18;
    }

    public static Object getLiteralValue(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return insn.getOpcode() - 3;
            }
            case 9: 
            case 10: {
                return (long)insn.getOpcode() - 9L;
            }
            case 11: 
            case 12: 
            case 13: {
                return Float.valueOf((float)insn.getOpcode() - 11.0f);
            }
            case 14: 
            case 15: {
                return (double)insn.getOpcode() - 14.0;
            }
            case 16: 
            case 17: {
                return ((IntInsnNode)insn).operand;
            }
            case 18: {
                return ((LdcInsnNode)insn).cst;
            }
        }
        throw new UnsupportedOperationException("No value retrieval method programmed for " + Utils.visitableToString(insn::accept).trim());
    }

    public static boolean isLiteral(AbstractInsnNode insn, Object literal) {
        Object literalValue = AbstractInsnNodes.getLiteralValue(insn);
        if (literal instanceof Character && literalValue instanceof Integer) {
            Character charLiteral = Character.valueOf((char)((Integer)literalValue).intValue());
            return literal.equals(charLiteral);
        }
        if (AbstractInsnNodes.isIntegral(literalValue) && AbstractInsnNodes.isIntegral(literal)) {
            return ((Number)literalValue).longValue() == ((Number)literal).longValue();
        }
        if (AbstractInsnNodes.isFloatingPoint(literalValue) && AbstractInsnNodes.isFloatingPoint(literal)) {
            return ((Number)literalValue).doubleValue() == ((Number)literal).doubleValue();
        }
        return literalValue.equals(literal);
    }

    private static boolean isIntegral(Object literal) {
        return literal instanceof Byte || literal instanceof Short || literal instanceof Integer || literal instanceof Long;
    }

    private static boolean isFloatingPoint(Object literal) {
        return literal instanceof Float || literal instanceof Double;
    }
}

