/*
 * Decompiled with CFR 0.152.
 */
package me.jamiemansfield.string;

public class StringReader {
    private final String source;
    private int index = 0;

    public StringReader(String source) {
        this.source = source;
    }

    public int length() {
        return this.source.length();
    }

    public int remaining() {
        return this.source.length() - this.index;
    }

    public int index() {
        return this.index;
    }

    public boolean readable(int offset) {
        return this.index + offset <= this.source.length();
    }

    public boolean available() {
        return this.readable(1);
    }

    public void skip(int length) {
        this.index += length;
    }

    public char peek() {
        return this.peek(0);
    }

    public char peek(int offset) {
        if (!this.readable(offset)) {
            throw new IllegalStateException("No character available to peek at!");
        }
        return this.source.charAt(this.index + offset);
    }

    public char advance() {
        return this.advance(0);
    }

    public char advance(int offset) {
        if (!this.readable(offset)) {
            throw new IllegalStateException("No character available to advance to!");
        }
        return this.source.charAt((this.index += offset + 1) - 1);
    }

    public String substring(int start, int end) {
        return this.source.substring(start, end);
    }
}

