/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.util;

import dev.denwav.hypo.model.HypoModelUtil;
import io.papermc.codebook.exceptions.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Manifest;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JarRunner {
    private final String name;
    private final List<Path> jars;
    private final List<String> arguments = new ArrayList<String>();
    private @Nullable String mainClass = null;

    private JarRunner(String name, List<Path> jars) {
        this.name = name;
        this.jars = jars;
    }

    public static JarRunner of(String name, List<Path> jars) {
        return new JarRunner(name, jars);
    }

    public JarRunner withArgs(String ... args) {
        return this.withArgs(Arrays.asList(args));
    }

    public JarRunner withArgs(Iterable<String> args) {
        for (String arg : args) {
            this.arguments.add(arg);
        }
        return this;
    }

    public JarRunner withMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public void run() {
        URL[] urls;
        try {
            urls = (URL[])this.jars.stream().map(HypoModelUtil.wrapFunction(j -> j.toUri().toURL())).toArray(URL[]::new);
        }
        catch (Exception e) {
            throw new UnexpectedException("Failed to create URLs from " + String.valueOf(this.jars), e);
        }
        try (URLClassLoader loader = new URLClassLoader(urls);){
            Method mainMethod = this.getMainMethod(loader);
            Thread thread = this.createThread(mainMethod, loader);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new UnexpectedException("Thread interrupted", e);
            }
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to run jar", e);
        }
    }

    private Thread createThread(Method mainMethod, ClassLoader loader) {
        Thread thread = new Thread(() -> {
            try {
                mainMethod.invoke(null, new Object[]{this.arguments.toArray(new String[0])});
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedException("Could not access main method", e);
            }
            catch (InvocationTargetException e) {
                throw new UnexpectedException("Failure occurred while running jar", e.getCause());
            }
        });
        thread.setContextClassLoader(loader);
        thread.setDaemon(false);
        thread.setName(this.name + " thread");
        return thread;
    }

    private Method getMainMethod(URLClassLoader loader) throws IOException {
        for (Path jar : this.jars) {
            @Nullable Method mainMethod = this.getMainMethod0(loader, jar);
            if (mainMethod == null) continue;
            return mainMethod;
        }
        throw new UnexpectedException("Failed to find main class in jars: " + String.valueOf(this.jars));
    }

    private @Nullable Method getMainMethod0(URLClassLoader loader, Path jar) throws IOException {
        Class<?> mainClass;
        String mainClassName;
        if (this.mainClass != null) {
            mainClassName = this.mainClass;
        } else {
            try (FileSystem fs = FileSystems.newFileSystem(jar);){
                Path manifest = fs.getPath("/", "META-INF", "MANIFEST.MF");
                if (Files.notExists(manifest, new LinkOption[0])) {
                    Method method = null;
                    return method;
                }
                try (InputStream input = Files.newInputStream(manifest, new OpenOption[0]);){
                    mainClassName = new Manifest(input).getMainAttributes().getValue("Main-Class");
                }
            }
        }
        if (mainClassName == null) {
            return null;
        }
        try {
            mainClass = Class.forName(mainClassName, true, loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            return mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

