/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import io.papermc.codebook.exceptions.UnexpectedException;
import io.papermc.codebook.lvt.LvtNamer;
import io.papermc.codebook.pages.CodeBookPage;
import io.papermc.codebook.report.Reports;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.cadixdev.lorenz.MappingSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RemapLvtPage
extends CodeBookPage {
    private final HypoContext context;
    private final @Nullable MappingSet paramMappings;
    private final Reports reports;

    @Inject
    public RemapLvtPage(@CodeBookPage.Hypo HypoContext hypoContext, @CodeBookPage.ParamMappings @Nullable MappingSet paramMappings, @CodeBookPage.Report Reports reports) {
        this.context = hypoContext;
        this.paramMappings = paramMappings;
        this.reports = reports;
    }

    @Override
    public void exec() {
        LvtNamer lvtNamer;
        if (this.paramMappings == null) {
            return;
        }
        try {
            lvtNamer = new LvtNamer(this.context, this.paramMappings, this.reports);
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to create LVT namer", e);
        }
        this.remapLvt(lvtNamer);
    }

    private void remapLvt(LvtNamer lvtNamer) {
        ArrayList tasks = new ArrayList();
        for (ClassData classData : this.context.getProvider().allClasses()) {
            Future<?> task = this.context.getExecutor().submit(() -> {
                try {
                    lvtNamer.processClass((AsmClassData)classData);
                }
                catch (Exception e) {
                    throw HypoModelUtil.rethrow(e);
                }
            });
            tasks.add(task);
        }
        try {
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            throw new UnexpectedException("Failed to remap LVT", e.getCause());
        }
        catch (InterruptedException e) {
            throw new UnexpectedException("LVT remap interrupted", e);
        }
    }
}

