/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion;

import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.types.PrimitiveType;
import io.papermc.codebook.lvt.LvtUtil;
import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PositionsSuggester
implements LvtSuggester {
    private static final String[] COMMON_PERSISTENT_PREFIXES = new String[]{"min", "max"};

    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) throws IOException {
        if ("net/minecraft/core/SectionPos".equals(insn.owner().name())) {
            return PositionsSuggester.suggestNameForSectionPos(container.node(), call.data(), insn.node());
        }
        if ("net/minecraft/core/QuartPos".equals(insn.owner().name())) {
            return PositionsSuggester.suggestNameForQuartPos(container.node(), call.data(), insn.node());
        }
        if ("net/minecraft/core/BlockPos".equals(insn.owner().name())) {
            return PositionsSuggester.suggestNameForBlockPos(call.data());
        }
        if ("net/minecraft/world/level/ChunkPos".equals(insn.owner().name())) {
            return PositionsSuggester.suggestNameForChunkPos(call.data());
        }
        return null;
    }

    private static @Nullable String suggestNameForSectionPos(MethodNode enclosingMethodNode, MethodData method, MethodInsnNode insn) {
        String possibleSimpleName;
        switch (method.name()) {
            case "x": {
                String string = "sectionX";
                break;
            }
            case "y": {
                String string = "sectionY";
                break;
            }
            case "z": {
                String string = "sectionZ";
                break;
            }
            case "blockToSection": 
            case "asLong": {
                String string = "packedSectionPos";
                break;
            }
            default: {
                String string = possibleSimpleName = null;
            }
        }
        if (possibleSimpleName != null) {
            return possibleSimpleName;
        }
        MethodConfig methodConfig = switch (method.name()) {
            case "blockToSectionCoord", "posToSectionCoord" -> new MethodConfig(PosType.SECTION, PosType.BLOCK);
            case "sectionToBlockCoord" -> new MethodConfig(PosType.BLOCK, PosType.SECTION);
            case "sectionRelative" -> new MethodConfig(PosType.BLOCK, PosType.BLOCK, "relative");
            default -> null;
        };
        return PositionsSuggester.getCoordLocalNameFromMethodPair(enclosingMethodNode, insn, method, methodConfig);
    }

    private static @Nullable String suggestNameForQuartPos(MethodNode enclosingMethodNode, MethodData method, MethodInsnNode insn) {
        MethodConfig methodConfig;
        if (method.params().size() != 1 || method.param(0) != PrimitiveType.INT || method.returnType() != PrimitiveType.INT) {
            return null;
        }
        switch (method.name()) {
            case "fromBlock": {
                MethodConfig methodConfig2 = new MethodConfig(PosType.QUART, PosType.BLOCK);
                break;
            }
            case "toBlock": {
                MethodConfig methodConfig2 = new MethodConfig(PosType.BLOCK, PosType.QUART);
                break;
            }
            case "fromSection": {
                MethodConfig methodConfig2 = new MethodConfig(PosType.QUART, PosType.SECTION);
                break;
            }
            case "toSection": {
                MethodConfig methodConfig2 = new MethodConfig(PosType.SECTION, PosType.QUART);
                break;
            }
            default: {
                MethodConfig methodConfig2 = methodConfig = null;
            }
        }
        if (methodConfig == null) {
            return null;
        }
        return PositionsSuggester.getCoordLocalNameFromMethodPair(enclosingMethodNode, insn, method, methodConfig);
    }

    private static @Nullable String suggestNameForBlockPos(MethodData method) {
        String suggestion;
        if (method.name().equals("asLong")) {
            suggestion = "packedBlockPos";
        } else if (method.isStatic() && method.name().equals("offset") && method.returnType() == PrimitiveType.LONG) {
            suggestion = "offsetPackedBlockPos";
        } else {
            return null;
        }
        return suggestion;
    }

    private static @Nullable String suggestNameForChunkPos(MethodData method) {
        if (!method.name().equals("asLong") && !method.name().equals("toLong")) {
            return null;
        }
        String suggestion = "packedChunkPos";
        return suggestion;
    }

    private static @Nullable String getCoordLocalNameFromMethodPair(MethodNode enclosingMethodNode, MethodInsnNode insn, MethodData method, @Nullable MethodConfig methodConfig) {
        FieldInsnNode fieldNode;
        if (methodConfig == null) {
            return null;
        }
        if (method.params().size() != 1) {
            return methodConfig.varName("Coord");
        }
        AbstractInsnNode prev = Objects.requireNonNull(LvtUtil.prevInsnIgnoringConvertCast(insn));
        String suggestion = null;
        if (prev instanceof VarInsnNode) {
            VarInsnNode varNode = (VarInsnNode)prev;
            LocalVariableNode paramVarNode = PositionsSuggester.findLocalVar(enclosingMethodNode, insn, varNode.var);
            suggestion = PositionsSuggester.suggestSpecificCoordName(methodConfig, paramVarNode.name, COMMON_PERSISTENT_PREFIXES);
        } else if (prev instanceof MethodInsnNode) {
            String strippedName;
            MethodInsnNode methodNode = (MethodInsnNode)prev;
            String string = strippedName = methodNode.name.startsWith("get") ? LvtUtil.decapitalize(methodNode.name.substring(3)) : methodNode.name;
            if (strippedName != null) {
                suggestion = PositionsSuggester.suggestSpecificCoordName(methodConfig, strippedName, COMMON_PERSISTENT_PREFIXES);
            }
        } else if (prev instanceof FieldInsnNode && (fieldNode = (FieldInsnNode)prev).getOpcode() == 180) {
            suggestion = PositionsSuggester.suggestSpecificCoordName(methodConfig, fieldNode.name, COMMON_PERSISTENT_PREFIXES);
        }
        return Objects.requireNonNullElseGet(suggestion, () -> methodConfig.varName("Coord"));
    }

    private static @Nullable String suggestSpecificCoordName(MethodConfig methodConfig, String fullName, String ... persistentPrefixes) {
        String nameWithoutPrefix;
        int possibleCoordIdx;
        String prefix = "";
        if (fullName.length() > 1) {
            for (String persistentPrefix : persistentPrefixes) {
                if (!fullName.startsWith(persistentPrefix)) continue;
                prefix = persistentPrefix;
                break;
            }
        }
        if ((possibleCoordIdx = PositionsSuggester.getPossibleCoordIdx(nameWithoutPrefix = fullName.substring(prefix.length()))) > -1 && (nameWithoutPrefix.length() == 1 || methodConfig.paramType.possibleNames.contains(nameWithoutPrefix.substring(0, possibleCoordIdx).toLowerCase(Locale.ENGLISH)))) {
            return methodConfig.varName(LvtUtil.capitalize(prefix, 0) + Character.toUpperCase(nameWithoutPrefix.charAt(possibleCoordIdx)));
        }
        return null;
    }

    private static int getPossibleCoordIdx(String name) {
        for (int i = name.length() - 1; i >= 0; --i) {
            char ch = name.charAt(i);
            if (!Character.isAlphabetic(ch)) continue;
            if (PositionsSuggester.isCoord(ch)) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    private static boolean isCoord(char ch) {
        return ch == 'X' || ch == 'Y' || ch == 'Z' || ch == 'x' || ch == 'y' || ch == 'z';
    }

    private static LocalVariableNode findLocalVar(MethodNode enclosingMethod, AbstractInsnNode insn, int varIdx) {
        ArrayList<LocalVariableNode> matching = new ArrayList<LocalVariableNode>();
        for (LocalVariableNode lvn : Objects.requireNonNull(enclosingMethod.localVariables)) {
            if (lvn.index != varIdx) continue;
            matching.add(lvn);
        }
        if (matching.isEmpty()) {
            throw new IllegalStateException("Cannot find idx " + varIdx + " on " + enclosingMethod.name + " " + enclosingMethod.desc + " (no match)");
        }
        if (matching.size() == 1) {
            return (LocalVariableNode)matching.get(0);
        }
        @Nullable AbstractInsnNode prev = insn.getPrevious();
        if (prev == null) {
            throw new IllegalStateException("Cannot find idx " + varIdx + " on " + enclosingMethod.name + " " + enclosingMethod.desc + " (multiple matches)");
        }
        while (true) {
            if (!(prev instanceof LabelNode)) {
                prev = prev.getPrevious();
                continue;
            }
            LabelNode labelNode = (LabelNode)prev;
            for (LocalVariableNode match : matching) {
                if (match.start.getLabel() != labelNode.getLabel()) continue;
                return match;
            }
            prev = prev.getPrevious();
        }
    }

    private record MethodConfig(PosType returnType, PosType paramType, String prefix) {
        private MethodConfig(PosType returnType, PosType paramType) {
            this(returnType, paramType, "");
        }

        String varName(String suffix) {
            if (this.prefix.isEmpty()) {
                return this.returnType.localName + suffix;
            }
            return this.prefix + LvtUtil.capitalize(this.returnType.localName, 0) + suffix;
        }
    }

    static enum PosType {
        BLOCK("block", "blockpos"),
        QUART("quart", "quartpos", "biome", "biomepos"),
        SECTION("section", "sectionpos");

        final Set<String> possibleNames;
        final String localName;

        private PosType(String ... possibleNames) {
            this.possibleNames = Set.of(possibleNames);
            this.localName = this.name().toLowerCase(Locale.ENGLISH) + "Pos";
        }
    }
}

