/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion;

import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MathSuggester
implements LvtSuggester {
    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) throws IOException {
        String methodName = call.data().name();
        if (insn.ownerEqualTo("java/lang/Math")) {
            return switch (methodName) {
                case "max" -> "max";
                case "min" -> "min";
                case "sqrt" -> "squareRoot";
                case "sin" -> "sin";
                case "cos" -> "cos";
                case "tan" -> "tan";
                case "asin" -> "asin";
                case "acos" -> "acos";
                case "atan" -> "atan";
                case "atan2" -> "atan2";
                case "sinh" -> "sinh";
                case "cosh" -> "cosh";
                case "tanh" -> "tanh";
                case "ceil" -> "ceil";
                case "floor" -> "floor";
                case "round" -> "rounded";
                case "abs" -> "abs";
                default -> null;
            };
        }
        if (insn.ownerEqualTo("net/minecraft/util/Mth")) {
            return switch (methodName) {
                case "abs" -> "abs";
                case "absMax" -> "max";
                case "sin" -> "sin";
                case "cos" -> "cos";
                case "sqrt" -> "squareRoot";
                case "invSqrt", "fastInvSqrt" -> "inverseSquareRoot";
                case "ceil" -> "ceil";
                case "floor" -> "floor";
                case "roundToward" -> "rounded";
                case "square" -> "squared";
                case "hsvToRgb" -> "rgb";
                case "binarySearch" -> "index";
                case "frac" -> "fraction";
                case "color" -> "color";
                case "equal" -> "isEqual";
                default -> null;
            };
        }
        return null;
    }
}

