/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.MethodDescriptor;
import dev.denwav.hypo.model.data.types.JvmType;
import io.papermc.codebook.lvt.LvtTypeSuggester;
import io.papermc.codebook.lvt.LvtUtil;
import io.papermc.codebook.lvt.suggestion.ComplexGetSuggester;
import io.papermc.codebook.lvt.suggestion.FluentGetterSuggester;
import io.papermc.codebook.lvt.suggestion.GenericSuggester;
import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.MathSuggester;
import io.papermc.codebook.lvt.suggestion.NewPrefixSuggester;
import io.papermc.codebook.lvt.suggestion.PositionsSuggester;
import io.papermc.codebook.lvt.suggestion.RecordComponentSuggester;
import io.papermc.codebook.lvt.suggestion.SingleVerbBooleanSuggester;
import io.papermc.codebook.lvt.suggestion.SingleVerbSuggester;
import io.papermc.codebook.lvt.suggestion.StringSuggester;
import io.papermc.codebook.lvt.suggestion.VerbPrefixBooleanSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.field.FieldCallContext;
import io.papermc.codebook.lvt.suggestion.context.field.FieldInsnContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import io.papermc.codebook.lvt.suggestion.numbers.MthRandomSuggester;
import io.papermc.codebook.lvt.suggestion.numbers.RandomSourceSuggester;
import io.papermc.codebook.report.type.MissingMethodLvtSuggestion;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class RootLvtSuggester
extends AbstractModule
implements LvtSuggester {
    private static final List<Class<? extends LvtSuggester>> SUGGESTERS = List.of(RandomSourceSuggester.class, MthRandomSuggester.class, MathSuggester.class, StringSuggester.class, PositionsSuggester.class, ComplexGetSuggester.class, NewPrefixSuggester.class, SingleVerbSuggester.class, VerbPrefixBooleanSuggester.class, SingleVerbBooleanSuggester.class, FluentGetterSuggester.class, RecordComponentSuggester.class, GenericSuggester.class);
    private final HypoContext hypoContext;
    private final LvtTypeSuggester lvtTypeSuggester;
    private final Injector injector;
    private final List<? extends LvtSuggester> suggesters;
    private static final Set<BoxMethod> BOX_METHODS = Set.of(new BoxMethod("java/lang/Byte", "byteValue", "()B"), new BoxMethod("java/lang/Short", "shortValue", "()S"), new BoxMethod("java/lang/Integer", "intValue", "()I"), new BoxMethod("java/lang/Long", "longValue", "()J"), new BoxMethod("java/lang/Float", "floatValue", "()F"), new BoxMethod("java/lang/Double", "doubleValue", "()D"), new BoxMethod("java/lang/Boolean", "booleanValue", "()Z"), new BoxMethod("java/lang/Character", "charValue", "()C"));
    private static final Set<String> BOX_METHOD_NAMES = BOX_METHODS.stream().map(BoxMethod::name).collect(Collectors.toUnmodifiableSet());
    private static final Set<String> JAVA_KEYWORDS = Set.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "exports", "module", "non-sealed", "open", "opens", "permits", "provides", "record", "sealed", "transitive", "uses", "var", "with", "yield");

    public RootLvtSuggester(HypoContext hypoContext, LvtTypeSuggester lvtTypeSuggester, Injector reports) {
        this.hypoContext = hypoContext;
        this.lvtTypeSuggester = lvtTypeSuggester;
        this.injector = reports.createChildInjector(this);
        this.suggesters = SUGGESTERS.stream().map(this.injector::getInstance).toList();
    }

    @Override
    protected void configure() {
        this.bind(HypoContext.class).toInstance(this.hypoContext);
        this.bind(LvtTypeSuggester.class).toInstance(this.lvtTypeSuggester);
    }

    public String suggestName(MethodData parent, MethodNode node, LocalVariableNode lvt, Set<String> scopedNames) throws IOException {
        String suggestedName;
        Object prev;
        int op;
        VarInsnNode assignmentNode = null;
        if (lvt.start.getPrevious() != null && (op = ((AbstractInsnNode)(prev = lvt.start.getPrevious())).getOpcode()) >= 54 && op <= 58) {
            VarInsnNode varInsn = (VarInsnNode)prev;
            if (varInsn.var == lvt.index) {
                assignmentNode = varInsn;
            }
        }
        if (assignmentNode == null) {
            for (AbstractInsnNode insn : node.instructions) {
                int op2 = insn.getOpcode();
                if (op2 < 54 || op2 > 58) continue;
                VarInsnNode varInsn = (VarInsnNode)insn;
                if (varInsn.var != lvt.index) continue;
                assignmentNode = varInsn;
                break;
            }
        }
        if (assignmentNode != null && (suggestedName = this.suggestNameFromFirstAssignment(parent, assignmentNode)) != null) {
            return RootLvtSuggester.determineFinalName(suggestedName, scopedNames);
        }
        JvmType lvtType = LvtUtil.toJvmType(lvt.desc);
        return RootLvtSuggester.determineFinalName(this.lvtTypeSuggester.suggestNameFromType(lvtType), scopedNames);
    }

    public static String determineFinalName(String suggestedName, Set<String> scopedNames) {
        Object name = JAVA_KEYWORDS.contains(suggestedName) ? "_" + suggestedName : suggestedName;
        if (scopedNames.add((String)name)) {
            return name;
        }
        int counter = 1;
        String nextSuggestedName;
        while (!scopedNames.add(nextSuggestedName = (String)name + counter)) {
            ++counter;
        }
        return nextSuggestedName;
    }

    private @Nullable AbstractInsnNode walkBack(VarInsnNode assignmentNode) {
        AbstractInsnNode prev = assignmentNode.getPrevious();
        if (prev != null) {
            int op = prev.getOpcode();
            if (op == 182) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)prev;
                if (BOX_METHOD_NAMES.contains(methodInsnNode.name) && BOX_METHODS.stream().anyMatch(bm -> bm.is(methodInsnNode))) {
                    if ((prev = prev.getPrevious()) != null && prev.getOpcode() == 192) {
                        return prev.getPrevious();
                    }
                    return prev;
                }
            }
            return prev;
        }
        return null;
    }

    private @Nullable String suggestNameFromFirstAssignment(MethodData parent, VarInsnNode varInsn) throws IOException {
        @Nullable AbstractInsnNode prev = this.walkBack(varInsn);
        if (prev == null) {
            return null;
        }
        int op = prev.getOpcode();
        if (op != 184 && op != 182 && op != 185) {
            return null;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)prev;
        @Nullable ClassData owner = this.hypoContext.getContextProvider().findClass(methodInsnNode.owner);
        if (owner == null) {
            return null;
        }
        @Nullable MethodData method = RootLvtSuggester.findMethod(owner, methodInsnNode.name, MethodDescriptor.parseDescriptor(methodInsnNode.desc));
        if (method == null) {
            return null;
        }
        return this.suggestFromMethod(MethodCallContext.create(method), MethodInsnContext.create(owner, methodInsnNode), ContainerContext.from(parent));
    }

    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) throws IOException {
        for (LvtSuggester lvtSuggester : this.suggesters) {
            @Nullable String suggestion = lvtSuggester.suggestFromMethod(call, insn, container);
            if (suggestion == null) continue;
            return suggestion;
        }
        this.injector.getInstance(MissingMethodLvtSuggestion.class).reportMissingMethodLvtSuggestion(call.data(), insn.node());
        return null;
    }

    @Override
    public @Nullable String suggestFromField(FieldCallContext call, FieldInsnContext insn, ContainerContext container) throws IOException {
        for (LvtSuggester lvtSuggester : this.suggesters) {
            @Nullable String suggestion = lvtSuggester.suggestFromField(call, insn, container);
            if (suggestion == null) continue;
            return suggestion;
        }
        return null;
    }

    private static @Nullable MethodData findMethod(@Nullable ClassData data, String name, MethodDescriptor desc) throws IOException {
        MethodData method;
        if (data == null) {
            return null;
        }
        @Nullable MethodData method2 = data.method(name, desc);
        if (method2 != null) {
            return method2;
        }
        @Nullable ClassData superClass = data.superClass();
        if (superClass != null && (method = RootLvtSuggester.findMethod(superClass, name, desc)) != null) {
            return method;
        }
        for (ClassData anInterface : data.interfaces()) {
            @Nullable MethodData method3 = RootLvtSuggester.findMethod(anInterface, name, desc);
            if (method3 == null) continue;
            return method3;
        }
        return null;
    }

    private record BoxMethod(String owner, String name, String desc) {
        boolean is(MethodInsnNode node) {
            return this.owner.equals(node.owner) && this.name.equals(node.name) && this.desc.equals(node.desc) && !node.itf;
        }
    }
}

