/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt;

import dev.denwav.hypo.asm.HypoAsmUtil;
import dev.denwav.hypo.model.data.types.JvmType;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public final class LvtUtil {
    private LvtUtil() {
    }

    public static JvmType toJvmType(String desc) {
        return HypoAsmUtil.toJvmType(Type.getType(desc));
    }

    public static String capitalize(String name, int index) {
        if (name.isEmpty()) {
            return name;
        }
        return Character.toUpperCase(name.charAt(index)) + name.substring(index + 1);
    }

    public static String decapitalize(String name) {
        boolean capturingGroup = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (Character.isUpperCase(character)) {
                if (capturingGroup) {
                    if (i < name.length() - 1 && Character.isLowerCase(name.charAt(i + 1))) {
                        result.append(character);
                        continue;
                    }
                    result.append(Character.toLowerCase(character));
                    continue;
                }
                capturingGroup = true;
                result.append(i == 0 ? Character.toLowerCase(character) : character);
                continue;
            }
            capturingGroup = false;
            result.append(character);
        }
        return result.toString();
    }

    public static Predicate<String> equalsAny(String ... strings) {
        return s2 -> {
            for (String string : strings) {
                if (!string.equals(s2)) continue;
                return true;
            }
            return false;
        };
    }

    public static String findNextWord(int start, String str) {
        StringBuilder nextWord = new StringBuilder();
        for (int i = start; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (nextWord.isEmpty()) {
                nextWord.append(ch);
                continue;
            }
            if (Character.isUpperCase(ch)) break;
            nextWord.append(ch);
        }
        return nextWord.toString();
    }

    public static @Nullable String tryMatchPrefix(String methodName, List<String> possiblePrefixes) {
        if (possiblePrefixes.contains(methodName)) {
            return null;
        }
        @Nullable String prefix = null;
        for (String possiblePrefix : possiblePrefixes) {
            if (!LvtUtil.hasPrefix(methodName, possiblePrefix)) continue;
            prefix = possiblePrefix;
            break;
        }
        return prefix;
    }

    public static boolean isStringAllUppercase(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (!Character.isAlphabetic(ch) || Character.isUpperCase(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPrefix(String text, String prefix) {
        return text.length() > prefix.length() && text.startsWith(prefix);
    }

    public static String parseSimpleTypeName(String simpleName) {
        if (LvtUtil.isStringAllUppercase(simpleName)) {
            return simpleName.toLowerCase(Locale.ROOT);
        }
        return LvtUtil.decapitalize(simpleName);
    }

    public static @Nullable String parseSimpleTypeNameFromMethod(String methodName, int prefix) {
        if (!Character.isUpperCase(methodName.charAt(prefix))) {
            return null;
        }
        return LvtUtil.parseSimpleTypeName(methodName.substring(prefix));
    }

    public static @Nullable AbstractInsnNode prevInsnIgnoringConvertCast(AbstractInsnNode insn) {
        AbstractInsnNode prev;
        for (prev = insn.getPrevious(); prev != null && (prev.getOpcode() == 192 || prev.getOpcode() >= 133 && prev.getOpcode() <= 147); prev = prev.getPrevious()) {
        }
        return prev;
    }

    public static String staticFinalFieldNameToLocalName(String fieldName) {
        String[] split = fieldName.split("_");
        StringBuilder builder = new StringBuilder();
        builder.append(split[0].toLowerCase(Locale.ENGLISH));
        for (int i = 1; i < split.length; ++i) {
            builder.append(LvtUtil.capitalize(split[i].toLowerCase(Locale.ENGLISH), 0));
        }
        return builder.toString();
    }
}

