/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt;

import com.google.common.base.Splitter;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.types.ArrayType;
import dev.denwav.hypo.model.data.types.ClassType;
import dev.denwav.hypo.model.data.types.JvmType;
import dev.denwav.hypo.model.data.types.PrimitiveType;
import io.papermc.codebook.lvt.LvtUtil;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LvtTypeSuggester {
    private final ClassData listClass;
    private final ClassData setClass;
    private final ClassData mapClass;
    private final HypoContext context;
    private static final Splitter dollarSplitter = Splitter.on('$');

    public LvtTypeSuggester(HypoContext context) throws IOException {
        this.context = context;
        @Nullable ClassData list = context.getContextProvider().findClass("java/util/List");
        @Nullable ClassData set = context.getContextProvider().findClass("java/util/Set");
        @Nullable ClassData map = context.getContextProvider().findClass("java/util/Map");
        this.listClass = Objects.requireNonNull(list, "java/util/List not found");
        this.setClass = Objects.requireNonNull(set, "java/util/Set not found");
        this.mapClass = Objects.requireNonNull(map, "java/util/Map not found");
    }

    public String suggestNameFromType(JvmType type) throws IOException {
        if (type instanceof PrimitiveType) {
            return switch ((PrimitiveType)type) {
                default -> throw new IncompatibleClassChangeError();
                case PrimitiveType.CHAR -> "c";
                case PrimitiveType.BYTE -> "b";
                case PrimitiveType.SHORT -> "s";
                case PrimitiveType.INT -> "i";
                case PrimitiveType.LONG -> "l";
                case PrimitiveType.FLOAT -> "f";
                case PrimitiveType.DOUBLE -> "d";
                case PrimitiveType.BOOLEAN -> "flag";
                case PrimitiveType.VOID -> throw new IllegalStateException("Illegal local variable type: " + String.valueOf(type));
            };
        }
        if (type instanceof ClassType) {
            return this.suggestNameFromClassType((ClassType)type);
        }
        if (type instanceof ArrayType) {
            JvmType baseType = ((ArrayType)type).baseType();
            if (baseType instanceof PrimitiveType) {
                return switch ((PrimitiveType)baseType) {
                    default -> throw new IncompatibleClassChangeError();
                    case PrimitiveType.CHAR -> "chars";
                    case PrimitiveType.BYTE -> "bytes";
                    case PrimitiveType.SHORT -> "shorts";
                    case PrimitiveType.INT -> "ints";
                    case PrimitiveType.LONG -> "longs";
                    case PrimitiveType.FLOAT -> "floats";
                    case PrimitiveType.DOUBLE -> "doubles";
                    case PrimitiveType.BOOLEAN -> "flags";
                    case PrimitiveType.VOID -> throw new IllegalStateException("Illegal local variable type: " + String.valueOf(type));
                };
            }
            return this.suggestNameFromType(baseType) + "s";
        }
        throw new IllegalStateException("Unknown type: " + String.valueOf(type));
    }

    private String suggestNameFromClassType(ClassType type) throws IOException {
        String name = type.asInternalName();
        if (name.equals("Ljava/lang/String;")) {
            return "string";
        }
        if (name.equals("Ljava/lang/Class;")) {
            return "clazz";
        }
        @Nullable ClassData typeClass = this.context.getContextProvider().findClass(type);
        if (typeClass != null) {
            if (typeClass.doesExtendOrImplement(this.listClass) && !typeClass.name().startsWith("net/minecraft/nbt/")) {
                return "list";
            }
            if (typeClass.doesExtendOrImplement(this.setClass)) {
                return "set";
            }
            if (typeClass.doesExtendOrImplement(this.mapClass)) {
                return "map";
            }
        }
        String baseName = name.substring(1, name.length() - 1);
        String simpleName = LvtTypeSuggester.getSimpleName(baseName);
        return LvtUtil.parseSimpleTypeName(simpleName);
    }

    private static String getSimpleName(String name) {
        int index = name.lastIndexOf(47);
        String className = index != -1 ? name.substring(index + 1) : name;
        if (className.isBlank()) {
            return "var";
        }
        int dollarIndex = className.lastIndexOf(36);
        if (dollarIndex == -1) {
            return className;
        }
        List<String> parts = dollarSplitter.splitToList(name);
        for (int i = parts.size() - 1; i >= 0; --i) {
            String part = parts.get(i);
            int goodIndex = LvtTypeSuggester.firstGoodIndex(part);
            if (goodIndex == -1) continue;
            if (goodIndex == 0) {
                return part;
            }
            return part.substring(goodIndex);
        }
        return "var";
    }

    private static int firstGoodIndex(String part) {
        char c;
        int firstGoodIndex;
        int len = part.length();
        for (firstGoodIndex = 0; firstGoodIndex < len && !Character.isJavaIdentifierStart(c = part.charAt(firstGoodIndex)); ++firstGoodIndex) {
        }
        if (len - firstGoodIndex <= 1) {
            return -1;
        }
        return firstGoodIndex;
    }
}

