/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt;

import com.google.inject.Guice;
import com.google.inject.Injector;
import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.asm.AsmMethodData;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.hydrate.generic.LambdaClosure;
import dev.denwav.hypo.hydrate.generic.LocalClassClosure;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.HypoKey;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.types.JvmType;
import dev.denwav.hypo.model.data.types.PrimitiveType;
import io.papermc.codebook.lvt.LvtTypeSuggester;
import io.papermc.codebook.lvt.RootLvtSuggester;
import io.papermc.codebook.report.ReportType;
import io.papermc.codebook.report.Reports;
import io.papermc.codebook.report.type.MissingMethodParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.Mapping;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;

public class LvtNamer {
    public static final HypoKey<Set<String>> SCOPED_NAMES = HypoKey.create("Scoped Names");
    private final MappingSet mappings;
    private final LvtTypeSuggester lvtTypeSuggester;
    private final Reports reports;
    private final Injector reportsInjector;
    private final RootLvtSuggester lvtAssignSuggester;

    public LvtNamer(HypoContext context, MappingSet mappings, Reports reports) throws IOException {
        this.mappings = mappings;
        this.lvtTypeSuggester = new LvtTypeSuggester(context);
        this.reports = reports;
        this.reportsInjector = Guice.createInjector(reports);
        this.lvtAssignSuggester = new RootLvtSuggester(context, this.lvtTypeSuggester, this.reportsInjector);
    }

    public void processClass(AsmClassData classData) throws IOException {
        for (MethodData method : classData.methods()) {
            this.fillNames(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillNames(MethodData method) throws IOException {
        MethodData methodData = method;
        synchronized (methodData) {
            this.fillNames0(method);
        }
    }

    private void fillNames0(MethodData method) throws IOException {
        Object outerScope;
        List<LocalClassClosure> localClasses;
        @Nullable Set<String> names = method.get(SCOPED_NAMES);
        if (names != null) {
            return;
        }
        @Nullable AsmMethodData outerMethod = null;
        int[] outerMethodParamLvtIndices = null;
        LambdaClosure lambdaClosure = null;
        @Nullable List<LambdaClosure> lambdaCalls = method.get(HypoHydration.LAMBDA_CALLS);
        if (lambdaCalls != null && method.isSynthetic()) {
            for (LambdaClosure lambdaCall : lambdaCalls) {
                if (!lambdaCall.getLambda().equals(method)) continue;
                outerMethod = (AsmMethodData)lambdaCall.getContainingMethod();
                if (outerMethod.equals(method)) {
                    outerMethod = null;
                    continue;
                }
                outerMethodParamLvtIndices = lambdaCall.getParamLvtIndices();
                lambdaClosure = lambdaCall;
                break;
            }
        }
        MethodNode node = ((AsmMethodData)method).getNode();
        ClassData parentClass = method.parentClass();
        Set<Object> innerClassFieldNames = Set.of();
        LocalClassClosure localClassClosure = null;
        int[] innerClassOuterMethodParamLvtIndices = null;
        if (outerMethod == null && (localClasses = parentClass.get(HypoHydration.LOCAL_CLASSES)) != null && !localClasses.isEmpty()) {
            localClassClosure = localClasses.get(0);
            outerMethod = (AsmMethodData)localClassClosure.getContainingMethod();
            innerClassFieldNames = LvtNamer.collectAllFields(parentClass);
            innerClassOuterMethodParamLvtIndices = localClassClosure.getParamLvtIndices();
        }
        if (outerMethod != null) {
            this.fillNames(outerMethod);
        }
        LinkedHashSet<String> scopedNames = outerMethod != null ? new LinkedHashSet((outerScope = outerMethod.get(SCOPED_NAMES)) == null ? Set.of() : outerScope) : new LinkedHashSet<String>();
        if (innerClassOuterMethodParamLvtIndices != null && !innerClassFieldNames.isEmpty()) {
            for (LocalVariableNode outerLvt : outerMethod.getNode().localVariables) {
                if (LvtNamer.find(innerClassOuterMethodParamLvtIndices, outerLvt.index) == -1 || !innerClassFieldNames.contains(outerLvt.name)) continue;
                LvtNamer.fixOuterScopeName(new ClosureInfo(localClassClosure.getContainingMethod(), localClassClosure.getParamLvtIndices()), outerLvt.name, RootLvtSuggester.determineFinalName(outerLvt.name, scopedNames), outerLvt.index);
            }
        }
        Optional methodMapping = this.mappings.getClassMapping(parentClass.name()).flatMap(c -> c.getMethodMapping(method.name(), method.descriptorText()));
        @Nullable ClassData superClass = parentClass.superClass();
        if (this.reports.shouldGenerate(ReportType.MISSING_METHOD_PARAM)) {
            this.reportsInjector.getInstance(MissingMethodParam.class).handleCheckingMappings(method, parentClass, superClass, lambdaCalls, methodMapping.orElse(null), outerMethodParamLvtIndices, lambdaClosure, localClassClosure);
        }
        if (node.localVariables == null) {
            List<JvmType> paramTypes = method.descriptor().getParams();
            int paramCount = paramTypes.size();
            if (node.parameters == null) {
                node.parameters = Arrays.asList(new ParameterNode[paramCount]);
            }
            for (int i = 0; i < paramCount; ++i) {
                int fi = i;
                @Nullable String paramName = methodMapping.flatMap(m4 -> m4.getParameterMapping(LvtNamer.fromParamToLvtIndex(fi, method))).map(Mapping::getDeobfuscatedName).orElse(null);
                if (paramName == null) {
                    paramName = this.lvtTypeSuggester.suggestNameFromType(paramTypes.get(i));
                }
                String finalName = RootLvtSuggester.determineFinalName(paramName, scopedNames);
                if (node.parameters.get(i) == null) {
                    node.parameters.set(i, new ParameterNode(finalName, 0));
                    continue;
                }
                node.parameters.get((int)i).name = finalName;
            }
            method.store(SCOPED_NAMES, scopedNames);
            return;
        }
        int[] ourCapturedLvts = new int[outerMethodParamLvtIndices == null ? 0 : outerMethodParamLvtIndices.length];
        Arrays.fill(ourCapturedLvts, -1);
        int ourCapturedLvtIndex = 0;
        if (outerMethodParamLvtIndices != null) {
            List<LocalVariableNode> outerLvts = outerMethod.getNode().localVariables;
            for (LocalVariableNode outerLvt : outerLvts) {
                int ourLvtIndex = LvtNamer.find(outerMethodParamLvtIndices, outerLvt.index);
                if (ourLvtIndex == -1 || LvtNamer.find(ourCapturedLvts, ourLvtIndex) != -1) continue;
                ourCapturedLvts[ourCapturedLvtIndex++] = ourLvtIndex;
                for (LocalVariableNode ourLvt : node.localVariables) {
                    if (ourLvt.index != ourLvtIndex || !ourLvt.desc.equals(outerLvt.desc)) continue;
                    ourLvt.name = outerLvt.name;
                }
                int ourLvtParamIndex = LvtNamer.fromLvtToParamIndex(ourLvtIndex, method);
                if (ourLvtParamIndex == -1 || node.parameters == null || node.parameters.size() <= ourLvtParamIndex) continue;
                node.parameters.get((int)ourLvtParamIndex).name = outerLvt.name;
            }
        }
        int usedNameIndex = 0;
        @Nullable UsedLvtName[] usedNames = new UsedLvtName[node.localVariables.size()];
        block5: for (LocalVariableNode lvt : node.localVariables) {
            String selectedName;
            if (lvt.index == 0 && !method.isStatic()) {
                if ("this".equals(lvt.name)) continue;
                lvt.name = "this";
                continue;
            }
            if (ourCapturedLvtIndex != -1 && LvtNamer.find(ourCapturedLvts, lvt.index) != -1) continue;
            for (int i = 0; i < usedNameIndex; ++i) {
                UsedLvtName used = usedNames[i];
                if (used == null || used.index != lvt.index || !used.desc.equals(lvt.desc)) continue;
                lvt.name = used.name;
                continue block5;
            }
            @Nullable String paramName = methodMapping.flatMap(m4 -> m4.getParameterMapping(lvt.index)).map(Mapping::getDeobfuscatedName).orElse(null);
            String mappedName = null;
            if (paramName != null) {
                mappedName = RootLvtSuggester.determineFinalName(paramName, scopedNames);
            }
            lvt.name = selectedName = mappedName != null ? mappedName : this.lvtAssignSuggester.suggestName(method, node, lvt, scopedNames);
            usedNames[usedNameIndex++] = new UsedLvtName(lvt.name, lvt.desc, lvt.index);
            int paramIndexFromLvt = LvtNamer.fromLvtToParamIndex(lvt.index, method);
            if (paramIndexFromLvt == -1 || node.parameters == null || node.parameters.size() <= paramIndexFromLvt) continue;
            node.parameters.get((int)paramIndexFromLvt).name = selectedName;
        }
        method.store(SCOPED_NAMES, scopedNames);
    }

    private static Set<String> collectAllFields(ClassData classData) throws IOException {
        HashSet<String> names = new HashSet<String>();
        LvtNamer._collectAllFields(classData, classData, names);
        names.removeIf(n -> n.startsWith("val$") || n.startsWith("this$"));
        return names;
    }

    private static void _collectAllFields(ClassData container, ClassData current, HashSet<String> res) throws IOException {
        ClassData superClass;
        List<FieldData> fields = current.fields();
        if (container == current) {
            for (FieldData field : fields) {
                res.add(field.name());
            }
        } else {
            for (FieldData field : fields) {
                switch (field.visibility()) {
                    case PUBLIC: 
                    case PROTECTED: {
                        res.add(field.name());
                        break;
                    }
                    case PACKAGE: {
                        if (!LvtNamer.packageName(container).equals(LvtNamer.packageName(current))) break;
                        res.add(field.name());
                    }
                }
            }
        }
        if ((superClass = current.superClass()) != null) {
            LvtNamer._collectAllFields(container, superClass, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fixOuterScopeName(ClosureInfo closureInfo, String badName, String newName, int lvtIndex) {
        MethodData containing = closureInfo.containing();
        MethodNode node = ((AsmMethodData)containing).getNode();
        for (LocalVariableNode localVariableNode : node.localVariables) {
            if (localVariableNode.index != lvtIndex || !localVariableNode.name.equals(badName)) continue;
            localVariableNode.name = newName;
        }
        int paramIndex = LvtNamer.fromLvtToParamIndex(lvtIndex, containing);
        if (paramIndex != -1 && node.parameters != null) {
            node.parameters.get((int)paramIndex).name = newName;
        }
        MethodData methodData = containing;
        synchronized (methodData) {
            @Nullable Set<String> containingScope = containing.get(SCOPED_NAMES);
            if (containingScope != null) {
                containingScope.add(newName);
            }
        }
        @Nullable List<LambdaClosure> list = containing.get(HypoHydration.LAMBDA_CALLS);
        @Nullable List<LocalClassClosure> localClasses = containing.get(HypoHydration.LOCAL_CLASSES);
        ArrayList<ClosureInfo> innerClosureContainingMethods = new ArrayList<ClosureInfo>((list != null ? list.size() : 0) + (localClasses != null ? localClasses.size() : 0));
        if (list != null) {
            for (LambdaClosure lambda : list) {
                if (lambda.getContainingMethod().equals(containing)) continue;
                innerClosureContainingMethods.add(new ClosureInfo(lambda.getContainingMethod(), lambda.getParamLvtIndices()));
            }
        }
        if (localClasses != null) {
            for (LocalClassClosure localClass : localClasses) {
                if (localClass.getContainingMethod().equals(containing)) continue;
                innerClosureContainingMethods.add(new ClosureInfo(localClass.getContainingMethod(), localClass.getParamLvtIndices()));
            }
        }
        for (ClosureInfo closure : innerClosureContainingMethods) {
            if (closure.paramLvtIndices().length <= lvtIndex) continue;
            LvtNamer.fixOuterScopeName(closure, badName, newName, closure.paramLvtIndices()[lvtIndex]);
        }
    }

    private static String packageName(ClassData classData) {
        String name = classData.name();
        int lastIndex = name.lastIndexOf(47);
        if (lastIndex == -1) {
            return name;
        }
        return name.substring(0, lastIndex);
    }

    private static int find(int[] array, int value) {
        return LvtNamer.find(array, value, array.length);
    }

    private static int find(int[] array, int value, int len) {
        for (int i = 0; i < len; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    private static int fromLvtToParamIndex(int lvtIndex, MethodData method) {
        int currentIndex = 0;
        int currentLvtIndex = method.isStatic() ? 0 : 1;
        for (JvmType param : method.params()) {
            if (currentLvtIndex == lvtIndex) {
                return currentIndex;
            }
            ++currentIndex;
            ++currentLvtIndex;
            if (param != PrimitiveType.LONG && param != PrimitiveType.DOUBLE) continue;
            ++currentLvtIndex;
        }
        return -1;
    }

    private static int fromParamToLvtIndex(int paramIndex, MethodData method) {
        int currentLvtIndex = method.isStatic() ? 0 : 1;
        int currentParamIndex = 0;
        for (JvmType param : method.params()) {
            if (currentParamIndex == paramIndex) {
                return currentLvtIndex;
            }
            ++currentParamIndex;
            ++currentLvtIndex;
            if (param != PrimitiveType.LONG && param != PrimitiveType.DOUBLE) continue;
            ++currentLvtIndex;
        }
        return -1;
    }

    private record ClosureInfo(MethodData containing, int[] paramLvtIndices) {
    }

    private record UsedLvtName(String name, String desc, int index) {
    }
}

