/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.config;

import io.papermc.codebook.config.CodeBookUriResource;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeBookUriResourceBuilder {
    private String name;
    private URI uri;
    private String sha1;

    private CodeBookUriResourceBuilder() {
    }

    private CodeBookUriResourceBuilder(String name, URI uri, String sha1) {
        this.name = name;
        this.uri = uri;
        this.sha1 = sha1;
    }

    public static CodeBookUriResource CodeBookUriResource(@NotNull String name, @NotNull URI uri, @Nullable String sha1) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(uri, "uri is required");
        return new CodeBookUriResource(name, uri, sha1);
    }

    public static CodeBookUriResourceBuilder builder() {
        return new CodeBookUriResourceBuilder();
    }

    public static CodeBookUriResourceBuilder builder(CodeBookUriResource from) {
        return new CodeBookUriResourceBuilder(from.name(), from.uri(), from.sha1());
    }

    public static With from(CodeBookUriResource from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(CodeBookUriResource record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, String>("name", record.name()), new AbstractMap.SimpleImmutableEntry<String, URI>("uri", record.uri()), new AbstractMap.SimpleImmutableEntry<String, String>("sha1", record.sha1()));
    }

    public CodeBookUriResource build() {
        Objects.requireNonNull(this.name, "name is required");
        Objects.requireNonNull(this.uri, "uri is required");
        return new CodeBookUriResource(this.name, this.uri, this.sha1);
    }

    public String toString() {
        return "CodeBookUriResourceBuilder[name=" + this.name + ", uri=" + String.valueOf(this.uri) + ", sha1=" + this.sha1 + "]";
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uri, this.sha1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof CodeBookUriResourceBuilder)) return false;
        CodeBookUriResourceBuilder r = (CodeBookUriResourceBuilder)o;
        if (!Objects.equals(this.name, r.name)) return false;
        if (!Objects.equals(this.uri, r.uri)) return false;
        if (!Objects.equals(this.sha1, r.sha1)) return false;
        return true;
    }

    public CodeBookUriResourceBuilder name(@NotNull String name) {
        this.name = name;
        return this;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public CodeBookUriResourceBuilder uri(@NotNull URI uri) {
        this.uri = uri;
        return this;
    }

    @NotNull
    public URI uri() {
        return this.uri;
    }

    public CodeBookUriResourceBuilder sha1(@Nullable String sha1) {
        this.sha1 = sha1;
        return this;
    }

    @Nullable
    public String sha1() {
        return this.sha1;
    }

    private static final class _FromWith
    implements With {
        private final CodeBookUriResource from;

        private _FromWith(CodeBookUriResource from) {
            this.from = from;
        }

        @Override
        public String name() {
            return this.from.name();
        }

        @Override
        public URI uri() {
            return this.from.uri();
        }

        @Override
        public String sha1() {
            return this.from.sha1();
        }
    }

    public static interface With {
        @NotNull
        public String name();

        @NotNull
        public URI uri();

        @Nullable
        public String sha1();

        default public CodeBookUriResourceBuilder with() {
            return new CodeBookUriResourceBuilder(this.name(), this.uri(), this.sha1());
        }

        default public CodeBookUriResource with(Consumer<CodeBookUriResourceBuilder> consumer) {
            CodeBookUriResourceBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public CodeBookUriResource withName(@NotNull String name) {
            Objects.requireNonNull(name, "name is required");
            return new CodeBookUriResource(name, this.uri(), this.sha1());
        }

        default public CodeBookUriResource withUri(@NotNull URI uri) {
            Objects.requireNonNull(uri, "uri is required");
            return new CodeBookUriResource(this.name(), uri, this.sha1());
        }

        default public CodeBookUriResource withSha1(@Nullable String sha1) {
            return new CodeBookUriResource(this.name(), this.uri(), sha1);
        }
    }
}

