/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.config;

import io.papermc.codebook.config.CodeBookJarInput;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CodeBookJarInputBuilder {
    private Path inputJar;
    private List<Path> classpathJars;

    private CodeBookJarInputBuilder() {
    }

    private CodeBookJarInputBuilder(Path inputJar, List<Path> classpathJars) {
        this.inputJar = inputJar;
        this.classpathJars = classpathJars;
    }

    public static CodeBookJarInput CodeBookJarInput(@NotNull Path inputJar, @NotNull List<Path> classpathJars) {
        classpathJars = CodeBookJarInputBuilder.__list(classpathJars);
        Objects.requireNonNull(inputJar, "inputJar is required");
        return new CodeBookJarInput(inputJar, classpathJars);
    }

    public static CodeBookJarInputBuilder builder() {
        return new CodeBookJarInputBuilder();
    }

    public static CodeBookJarInputBuilder builder(CodeBookJarInput from) {
        return new CodeBookJarInputBuilder(from.inputJar(), from.classpathJars());
    }

    public static With from(CodeBookJarInput from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(CodeBookJarInput record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, Path>("inputJar", record.inputJar()), new AbstractMap.SimpleImmutableEntry<String, List<Path>>("classpathJars", record.classpathJars()));
    }

    public CodeBookJarInput build() {
        this.classpathJars = CodeBookJarInputBuilder.__list(this.classpathJars);
        Objects.requireNonNull(this.inputJar, "inputJar is required");
        return new CodeBookJarInput(this.inputJar, this.classpathJars);
    }

    public String toString() {
        return "CodeBookJarInputBuilder[inputJar=" + String.valueOf(this.inputJar) + ", classpathJars=" + String.valueOf(this.classpathJars) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.inputJar, this.classpathJars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof CodeBookJarInputBuilder)) return false;
        CodeBookJarInputBuilder r = (CodeBookJarInputBuilder)o;
        if (!Objects.equals(this.inputJar, r.inputJar)) return false;
        if (!Objects.equals(this.classpathJars, r.classpathJars)) return false;
        return true;
    }

    public CodeBookJarInputBuilder inputJar(@NotNull Path inputJar) {
        this.inputJar = inputJar;
        return this;
    }

    @NotNull
    public Path inputJar() {
        return this.inputJar;
    }

    public CodeBookJarInputBuilder classpathJars(@NotNull Collection<? extends Path> classpathJars) {
        this.classpathJars = CodeBookJarInputBuilder.__list(classpathJars);
        return this;
    }

    @NotNull
    public List<Path> classpathJars() {
        return CodeBookJarInputBuilder.__list(this.classpathJars);
    }

    public CodeBookJarInputBuilder addClasspathJars(Path i) {
        this.classpathJars = CodeBookJarInputBuilder.__ensureListMutable(this.classpathJars);
        this.classpathJars.add(i);
        return this;
    }

    public CodeBookJarInputBuilder addClasspathJars(Stream<? extends Path> i) {
        this.classpathJars = CodeBookJarInputBuilder.__ensureListMutable(this.classpathJars);
        i.forEach(this.classpathJars::add);
        return this;
    }

    public CodeBookJarInputBuilder addClasspathJars(Iterable<? extends Path> i) {
        this.classpathJars = CodeBookJarInputBuilder.__ensureListMutable(this.classpathJars);
        i.forEach(this.classpathJars::add);
        return this;
    }

    private static <T> List<T> __list(Collection<? extends T> o) {
        return o != null ? List.copyOf(o) : List.of();
    }

    private static <T> List<T> __ensureListMutable(List<T> o) {
        if (o == null) {
            return new _MutableList();
        }
        if (o instanceof _MutableList) {
            return o;
        }
        return new _MutableList<T>(o);
    }

    private static final class _FromWith
    implements With {
        private final CodeBookJarInput from;

        private _FromWith(CodeBookJarInput from) {
            this.from = from;
        }

        @Override
        public Path inputJar() {
            return this.from.inputJar();
        }

        @Override
        public List<Path> classpathJars() {
            return this.from.classpathJars();
        }
    }

    private static class _MutableList<T>
    extends ArrayList<T> {
        _MutableList() {
        }

        _MutableList(List<T> o) {
            super(o);
        }
    }

    public static interface With {
        @NotNull
        public Path inputJar();

        @NotNull
        public List<Path> classpathJars();

        default public CodeBookJarInputBuilder with() {
            return new CodeBookJarInputBuilder(this.inputJar(), this.classpathJars());
        }

        default public CodeBookJarInput with(Consumer<CodeBookJarInputBuilder> consumer) {
            CodeBookJarInputBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public CodeBookJarInput withInputJar(@NotNull Path inputJar) {
            Objects.requireNonNull(inputJar, "inputJar is required");
            return new CodeBookJarInput(inputJar, this.classpathJars());
        }

        default public CodeBookJarInput withClasspathJars(@NotNull List<Path> classpathJars) {
            return new CodeBookJarInput(this.inputJar(), CodeBookJarInputBuilder.__list(classpathJars));
        }
    }
}

